<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Support\ValidationRule;
use App\Models\Admin\Periode;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redirect;

class PeriodeController extends Controller
{
    public function index(){
        $periode = Periode::query()->get();

        $data = [
            'periode' => $periode
        ];
        return view('Admin.Periode.index', $data);
    }

    public function store(Request $request){
    
        DB::beginTransaction();

        try{

            $rule = [
                'periode' => 'required',
                'tanggal_awal' => 'required|date',
                'tanggal_akhir' => 'required|date',
                'is_aktif'  => 'required'
            ];
    
            $request->validate($rule, ValidationRule::getErrorMessage($rule));

            $periode = [
                'periode' => $request->periode,
                'tanggal_awal' => $request->tanggal_awal,
                'tanggal_akhir' => $request->tanggal_akhir,
                'is_aktif' => $request->is_aktif,
            ];

            Periode::query()->create($periode);

            DB::commit();

            return Redirect::route('periode.index')
                ->with('success', 'Periode berhasil ditambahkan');
        }
        catch(Exception $e){
            Log::error($e);
            DB::rollBack();

            return Redirect::route('periode.index')
                ->with('error', 'Periode gagal ditambahkan');
        }
    }

    public function update(Request $request, $id){

        DB::beginTransaction();

        try{
            $id = decrypt($id);

            $rule = [
                'periode' => 'required',
                'tanggal_awal' => 'required|date',
                'tanggal_akhir' => 'required|date',
                'is_aktif' => 'required'
            ];
    
            $request->validate($rule, ValidationRule::getErrorMessage($rule));
    
                $periode = [
                    'periode' => $request->periode,
                    'tanggal_awal' => $request->tanggal_awal,
                    'tanggal_akhir' => $request->tanggal_akhir,
                    'is_aktif' => $request->is_aktif,
                ];

                Periode::where('periode', $id)->update($periode);

                DB::commit();

                return Redirect::route('periode.index')
                    ->with('success', 'Periode berhasil diupdate');
        }
        catch(Exception $e){
            Log::error($e);
            DB::rollBack();

            return Redirect::route('periode.index')
                ->with('error', 'Periode gagal diupdate');
        }
    }

    // public function destroy($id) {
    //     $id = decrypt($id);

    //     DB::beginTransaction();

    //     try{
    //         User::where('id', $id)->delete();

    //         DB::commit();

    //         return Redirect::route('user.index')
    //             ->with('success', 'User berhasil dihapus');
    //     }
    //     catch(Exception $e){
    //         Log::error($e);
    //         DB::rollBack();

    //         return Redirect::route('user.index')
    //             ->with('error', 'User gagal dihapus');
    //     }
    // }
}
