<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Pengajuan;
use Exception;
use GuzzleHttp\Client;
use Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Session;

class SakuController extends Controller
{

    public function index(Request $request) {
        // $penelaah = DB::table('tr_penelaah')->orderBy('id_pengajuan')->get();

        $filter_periode = DB::table('ms_periode')->orderBy('periode','asc')->get();

        Session::put('periode', $request->periode); 

        if(empty(Session::get('periode'))) {
            $periode = DB::table('ms_periode')->where('is_aktif', 1)->first();
            Session::put('periode', $periode->periode);
        } else {
            $periode = DB::table('ms_periode')->where('periode', Session::get('periode'))->first();
        }

        $penelaah = DB::table('tr_penelaah')
        ->select('tr_penelaah.*', 'tr_pengajuan.id_pengajuan as id_pengajuan_epk', 'tr_pengajuan.no_sk', 'tr_pengajuan.judul', 'tr_pengajuan.peneliti', 'tr_pengajuan.tahun', 'tr_pengajuan.klasifikasi', 'tr_pengajuan.file_ec', 'ms_kategori.nama_kategori')
        ->join('tr_pengajuan', 'tr_pengajuan.id', 'tr_penelaah.id_pengajuan')
        ->join('ms_kategori', 'ms_kategori.id', 'tr_pengajuan.id_kategori')
        ->join('bantuan_pengusul', 'bantuan_pengusul.id_pengajuan', 'tr_pengajuan.id_pengajuan')
        ->whereBetween('bantuan_pengusul.tanggal_keputusan', [$periode->tanggal_awal, $periode->tanggal_akhir])
        ->orderBy('id_pengajuan')
        ->get();

        $data = [
            'penelaah' => $penelaah,
            'periode'  => $filter_periode
        ];

        return view('saku.index', $data);
    }

    public function getFileName($tahun, $nosurat){
        $client = new Client();

        $response = $client->request('GET', 'https://e-office.unesa.ac.id/api/show-surat-keluar/'.$tahun.'/'.$nosurat);
        $data = json_decode($response->getBody(), true);

        if (is_null($data)) {
            $namafile = '';
        }
        if (empty($data)) {
            $namafile = '';
        }
        else{
            $namafile = $data['namafile'];
        }

        return $namafile;

    }
}
