<?php

namespace App\Http\Support;

class ValidationRule{
    const WARNING = [
        'required' => 'can not be empty',
        'numeric' => 'must be a number',
        'string' => 'must be a string',
        'unique' => 'must be unique',
        'regex' => 'must be a combination of uppercase letters, lowercase letters, numbers and characters',
        'max' => 'must be maximum',
        'min' => 'must be minimum',
        'email' => 'is invalid',
        'mimes' => 'file type must pdf',
        'date' => 'must be a valid date',  // Menambahkan pesan untuk date
        'unique' => 'must be unique'
    ];

    public static function getErrorMessage($validationRules) {
        $messages = [];
        foreach ($validationRules as $key => $rules) {
            $rulesArr = explode('|', $rules);

            foreach ($rulesArr as $rule) {
                $ruleArr = explode('|', $rule);
                $ruleParams = explode(':', $ruleArr[0]);
                $ruleKey = $ruleParams[0];

                $message = str_replace('inputs.', '', $key);
                $message = str_replace(['.', '_'], ' ', $message).' '.self::WARNING[$ruleKey].($ruleKey == 'max' || $ruleKey == 'min' ? ' '.$ruleParams[1].' characters' : '');
                $messages[$key.'.'.$ruleKey] = $message;
            }
        }
        return $messages;
    }
}

?>
