@extends('layouts.master')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="card">
        <div class="row layout-top-spacing" id="cancel-row">
            <h5 class="card-header" style="padding-left: 35px">Daftar Kategori</h5>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3" style="padding-left: 30px">
                        <button type="button" class="btn btn-primary text-right" data-bs-toggle="modal" data-bs-target="#addNewKategoriModal" >
                            Tambah Kategori
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive text-nowrap">
                    <table class="table">
                      <thead class="table-light" align="center">
                        <tr>
                          <th>No.</th>
                          <th>Kode Kategori</th>
                          <th>Nama Kategori</th>
                          {{-- <th>Poin SAKU</th> --}}
                          <th>Status</th>
                          <th>Aksi</th>
                        </tr>
                      </thead>
                      <tbody class="table-border-bottom-0">
                          @php
                              $no = 1;
                          @endphp
                          @foreach ($kategori as $kat)
                            @php
                                if($kat->status == "1"){
                                    $status = "Aktif";
                                }
                                else{
                                    $status = "Nonaktif";
                                }
                            @endphp
                            <tr style="text-align: center">
                                <td>{{ $no }}</td>
                                <td style="text-align: center">{{ $kat->kode_kategori }}</td>
                                <td>{{ $kat->nama_kategori }}</td>
                                {{-- <td>{{ $kat->poin_saku }}</td> --}}
                                <td>{{ $status }}</td>
                                <td>
                                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editKategoriModal{{$kat->id}}">Edit</button>
                                    <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteKategoriModal{{$kat->id}}">Hapus</button>
                                </td>
                            </tr>

                            <!-- Modal Update Kategori -->
                            <div class="modal fade" id="editKategoriModal{{$kat->id}}" tabindex="-1" aria-labelledby="tambahAntrian" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <form method="POST" action="{{ route('kategori.update', ['kategori' => encrypt($kat->id)]) }}" enctype="multipart/form-data" id="registrasi">
                                        @method('PUT')
                                        @csrf
                                    <div class="modal-header">
                                        <h1 class="address-title text-center mb-1" id="addNewKategoriTitle">Edit Kategori</h1>
                                    </div>
                                    <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label class="form-label" for="kodekategori">Kode Kategori</label>
                                            <input type="text" class="form-control" id="kodekategori" name="kodekategori" placeholder="Kode Kategori" data-msg="Masukkan Kode Kategori" value="{{$kat->kode_kategori}}" required />
                                            @if ($errors->has('kodekategori'))
                                                <label id="login-error" class="error" for="kodekategori" style="color: red">{{$errors->first('kodekategori')}}</label>
                                            @endif
                                        </div>
                                        {{-- <div class="col-md-6">
                                            <label class="form-label" for="poinsaku">Poin Saku</label>
                                            <input type="text" id="poinsaku" name="poinsaku" class="form-control" placeholder="Poin SAKU" data-msg="Masukkan Poin SAKU" value="{{$kat->poin_saku}}" required />
                                            @if ($errors->has('poinsaku'))
                                                <label id="login-error" class="error" for="poinsaku" style="color: red">{{$errors->first('poinsaku')}}</label>
                                            @endif
                                        </div> --}}
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label" for="namakategori">Nama Kategori</label>
                                        <input type="text" id="namakategori" name="namakategori" class="form-control" placeholder="Nama Kategori" data-msg="Masukkan Nama Kategori" value="{{$kat->nama_kategori}}" required />
                                        @if ($errors->has('namakategori'))
                                            <label id="login-error" class="error" for="namakategori" style="color: red">{{$errors->first('namakategori')}}</label>
                                        @endif
                                    </div>
                                    <div class="col-md-12">
                                        <label class="form-label" for="status">Status</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="0" @if ($kat->status == "0") {{"selected"}} @endif>Tidak Aktif</option>
                                            <option value="1" @if ($kat->status == "1") {{"selected"}} @endif>Aktif</option>
                                        </select>
                                    </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                                    </div>
                                    </form>
                                </div>
                                </div>
                            </div>
                            <!-- End Modal Update Kategori -->

                            <!-- Modal Delete Kategori -->
                            <div class="modal fade" id="deleteKategoriModal{{$kat->id}}" tabindex="-1" aria-labelledby="tambahAntrian" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <form method="POST" action="{{ route('kategori.destroy', ['kategori' => encrypt($kat->id) ]) }}" enctype="multipart/form-data">
                                        @csrf
                                        @method("DELETE")
                                        <div class="modal-header">
                                            <h1 class="address-title text-center mb-1" id="addNewKategoriTitle">Hapus Kategori</h1>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group" style="text-align: center">
                                                <h5 class="address-title text-center mb-3 mt-1" id="addNewAddressTitle">Apakah anda yakin ingin menghapus kategori ini?</h5>
                                            </div>
                                            <div class="form-group" style="text-align: center">
                                                <button type="submit" class="btn btn-primary ml-1">Delete</button>
                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                </div>
                            </div>
                            <!-- End Modal Delete Kategori -->
                            @php
                                $no++;
                            @endphp
                          @endforeach
                      </tbody>
                    </table>
                  </div>
            </div>
        </div>
    </div>

    <!-- Modal Tambah Kategori -->
    <div class="modal fade" id="addNewKategoriModal" tabindex="-1" aria-labelledby="tambahAntrian" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
            <form method="POST" action="{{ route('kategori.store') }}" enctype="multipart/form-data" id="registrasi">
                @csrf
            <div class="modal-header">
                <h1 class="address-title text-center mb-1" id="addNewKategoriTitle">Tambah Kategori</h1>
            </div>
            <div class="modal-body">
              <div class="row">
                <div class="col-md-12">
                    <label class="form-label" for="kodekategori">Kode Kategori</label>
                    <input type="text" class="form-control" id="kodekategori" name="kodekategori" placeholder="Kode Kategori" data-msg="Masukkan Kode Kategori" value="" required />
                    @if ($errors->has('kodekategori'))
                        <label id="login-error" class="error" for="kodekategori" style="color: red">{{$errors->first('kodekategori')}}</label>
                    @endif
                </div>
                {{-- <div class="col-md-6">
                    <label class="form-label" for="poinsaku">Poin Saku</label>
                    <input type="text" id="poinsaku" name="poinsaku" class="form-control" placeholder="Poin SAKU" data-msg="Masukkan Poin SAKU" required />
                    @if ($errors->has('poinsaku'))
                        <label id="login-error" class="error" for="poinsaku" style="color: red">{{$errors->first('poinsaku')}}</label>
                    @endif
                </div> --}}
              </div>
              <div class="col-md-12">
                <label class="form-label" for="namakategori">Nama Kategori</label>
                <input type="text" id="namakategori" name="namakategori" class="form-control" placeholder="Nama Kategori" data-msg="Masukkan Nama Kategori" required />
                @if ($errors->has('namakategori'))
                    <label id="login-error" class="error" for="namakategori" style="color: red">{{$errors->first('namakategori')}}</label>
                @endif
              </div>
              <hr>
              <div class="col-md-12">
                <label class="form-label" for="status">Status</label>
                <select name="status" id="status" class="form-control">
                    <option value="0">Tidak Aktif</option>
                    <option value="1">Aktif</option>
                </select>
              </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Submit</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
            </div>
            </form>
          </div>
        </div>
      </div>
    <!-- End Modal Tambah Kategori -->
</div>
@endsection
@push('js')
@endpush
