<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<!-- BEGIN: Head-->

<head>
    <link rel="apple-touch-icon" href="{{ url('theme/images/ico/apple-icon-120.png') }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ url('theme/images/ico/favicon.ico') }}">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600" rel="stylesheet">

    <meta http-equiv="Content-Type" charset="utf-8">
    <meta name="universitas-negeri-surabaya" content="custom" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Unesa Medical Center">
    <meta name="author" content="PPTI Unesa Surabaya">
    <meta name="keywords" content="sistem, informasi, klinik, obat, sakit, pengobatan, unesa, pasien, penyembuhan">
    <meta name="language" content="id">
    <meta name="geo.region" content="ID" />
    <meta name="geo.position" content="-7.300818;112.672689">
    <meta name="geo.placename" content="Surabaya">
    <meta name="geo.region" content="Indonesia">
    <title>SIPEKA | Sistem Informasi Pengkategorian EPK</title>

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('theme/vendors/css/vendors.min.css') }}">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/bootstrap.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/bootstrap-extended.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/colors.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/components.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/themes/dark-layout.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/themes/bordered-layout.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/themes/semi-dark-layout.css') }}">

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/core/menu/menu-types/horizontal-menu.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/plugins/forms/form-validation.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ url('theme/css/pages/authentication.css') }}">
    <!-- END: Page CSS-->

    <!-- BEGIN: Custom CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('theme/assets/css/style.css') }}">
    <!-- END: Custom CSS-->

</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="horizontal-layout horizontal-menu blank-page navbar-floating footer-static  " data-open="hover" data-menu="horizontal-menu" data-col="blank-page">
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body">
                <div class="auth-wrapper auth-basic px-2">
                    <div class="auth-inner my-2">
                        <!-- Login basic -->
                        <div class="card mb-0">
                            <div class="card-body">
                                <a href="index.html" class="brand-logo">
                                    {{-- <img src="{{ url('theme/images/logo/logoumc.png') }}" width="40%"> --}}
                                    <h2 class="brand-text text-primary ms-1">SIPEKA</h2>
                                </a>

                                {{-- <h4 class="card-title mb-1">Welcome to SIPEKA!</h4> --}}

                                <form class="text-left" method="POST" action="{{ route('login') }}">
                                    @csrf
                                    <div class="mb-1">
                                        <label for="login-email" class="form-label">Email</label>
                                        <input id="email" name="email" type="text" class="form-control" placeholder="Email" :value="old('email')" required autofocus>
                                    </div>

                                    <div class="mb-1">
                                        <div class="d-flex justify-content-between">
                                            <label class="form-label" for="login-password">Password</label>
                                        </div>
                                        <div class="input-group input-group-merge form-password-toggle">
                                            <input id="password" name="password" type="password" class="form-control" placeholder="Password" required autocomplete="current-password">
                                            <span class="input-group-text cursor-pointer"><i data-feather="eye"></i></span>
                                        </div>
                                    </div>

                                    <button class="btn btn-primary w-100" tabindex="4">Login</button>
                                </form>

                            </br>

                            </div>
                        </div>
                        <!-- /Login basic -->
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- END: Content-->


    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('theme/vendors/js/vendors.min.js') }}"></script>
    <!-- BEGIN Vendor JS-->

    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ url('theme/vendors/js/ui/jquery.sticky.js') }}"></script>
    <script src="{{ url('theme/vendors/js/forms/validation/jquery.validate.min.js') }}"></script>
    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="{{ url('theme/js/core/app-menu.js') }}"></script>
    <script src="{{ url('theme/js/core/app.js') }}"></script>
    <!-- END: Theme JS-->

    <!-- BEGIN: Page JS-->
    <script src="{{ url('theme/js/scripts/pages/auth-login.js') }}"></script>
    <!-- END: Page JS-->

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        })
    </script>
</body>
<!-- END: Body-->

</html>
