@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Daftar Reviewer</h4>
            </div>
            <div class="card-body">
                <div class="card-text">
                    <div class="row">
                        <div class="panel panel-info">
                            <div class="panel-body">
                                <form action="{{ route('saku.index') }}" method="GET">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>Periode</label>
                                            <select name="periode" class="form-control">
                                                @foreach($periode as $p)
                                                <option value={{ $p->periode }}  @if( Session::get('periode') == $p->periode) selected="selected" @endif>{{ $p->periode }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <br>
                                            <button class="btn btn-info pull-lefts">Cari</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>


            <div class="table-responsive mb-4">
                <table id="datatable" class="table data-table table-hover" style="width:100%">
                    <thead>
                        <tr>
                            <th>No</th>
                            {{-- <th>ID Pengajuan</th> --}}
                            <th style="text-align: left">File SK</th>
                            <th style="text-align: left">Nama/NIP</th>
                            <th style="text-align: left">Judul</th>
                            <th style="text-align: left">Tahun</th>
                            <th style="text-align: left">Klasifikasi</th>
                            <th style="text-align: left">File EC</th>
                            <th style="text-align: left">Kategori</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($penelaah->isNotEmpty())
                            @php
                                $no = 1;
                                $nomorsurat = $penelaah[0]->no_sk;
                                $no_surat = explode('/', $nomorsurat);
                                $jmlSukuNoSurat = count($no_surat);

                                if(ctype_digit($no_surat[0])){
                                    $noagenda = $no_surat[0];
                                }
                                elseif(ctype_digit($no_surat[1])){
                                    $noagenda = $no_surat[1];
                                }

                                $tahun = $no_surat[$jmlSukuNoSurat-1];
                                $namafile = app(App\Http\Controllers\Admin\SakuController::class)->getFileName($tahun, $noagenda);
                            @endphp
                            @foreach($penelaah as $key => $item)
                            @php
                                // $pengajuan = DB::table('tr_pengajuan')->where('id',$item->id_pengajuan)->first();
                                if($item->no_sk != $nomorsurat){
                                    $no_surat = explode('/', $item->no_sk);
                                    $jmlSukuNoSurat = count($no_surat);

                                    if(ctype_digit($no_surat[0])){
                                        $noagenda = $no_surat[0];
                                    }
                                    elseif(ctype_digit($no_surat[1])){
                                        $noagenda = $no_surat[1];
                                    }

                                    $tahun = $no_surat[$jmlSukuNoSurat-1];
                                    $namafile = app(App\Http\Controllers\Admin\SakuController::class)->getFileName($tahun, $noagenda);
                                }
                            @endphp
                                <tr>
                                    <td>{{ $no }}</td>
                                    {{-- <td>{{ $item->id_pengajuan_epk }}</td> --}}
                                    <td style="text-align: left"><a href="https://e-office.unesa.ac.id/dokumen/surat_keluar/{{$namafile}}" target="_blank"><img src="{{ url('assets/img/icons/misc/pdf.png') }}" alt="pdf" height="60" class="me-3" /></a></td>
                                    <td style="text-align: left">{{ $item->nama }}<br>
                                        <strong>{{ $item->nip }}</strong></td>
                                    <td style="text-align: left">{{ $item->judul }}</td>
                                    <td style="text-align: left">{{ $item->tahun }}</td>
                                    <td style="text-align: left">{{ $item->klasifikasi }}</td>
                                    <td style="text-align: left">
                                    @if(!empty($item->file_ec))
                                        <strong><a href="https://sipeka.unesa.ac.id/sipeka/file/{!!$item->file_ec!!}" target="_blank" class="btn btn-success btn-md">Lihat</a></strong>
                                    @endif
                                    </td>
                                    {{-- @php
                                        $kategori = DB::table('ms_kategori')->where('id',$pengajuan->id_kategori)->first();
                                    @endphp --}}
                                    <td style="text-align: left">{{ $item->nama_kategori }}</td>
                                </tr>
                                @php
                                    $no++;
                                @endphp
                            @endforeach
                        @else
                        <td colspan="8" style="text-align: center">Data tidak ditemukan.</td>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    </div>
</div>
@push('js')
<!-- Include DataTable JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/feather-icons"></script>
<script>
    $(document).ready(function() {
        $('#datatable').DataTable();
    });

    feather.replace();
</script>
@endpush
@stop
