@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Daftar Usulan</h4>
            </div>
            <div class="card-body">
                <div class="card-text">
                    <div class="row">
                        <div class="col-md-8">
                            {{-- @livewire('admin.masters.registrasi.add-registrasi-component') --}}
                        </div>
                        <div class="col-md-4 text-right">
                            {{-- <div class="row">
                                <label class="col-sm-3 col-form-label"></label>
                                <label class="col-sm-3 col-form-label">Cari : </label>
                                <div class="col-sm-6">
                                    <input type="text" class="form-control align-right" placeholder="Search" wire:model="keyword">
                                </div>
                            </div> --}}
                        </div>
                    </div>
                    <div class="row">
                        <div class="panel panel-info">
                            <div class="panel-body">
                                <form action="{{ route('transaksi.index') }}" method="GET">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>Status Kategori</label>
                                            <select name="status" class="form-control">
                                                <option value="">Semua</option>
                                                <option value="1"  @if( Session::get('status') == '1') selected="selected" @endif>SUDAH</option>
                                                <option value="2"  @if( Session::get('status') =='2') selected="selected" @endif>BELUM</option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label>Periode</label>
                                            <select name="periode" class="form-control">
                                                @foreach($periode as $p)
                                                <option value={{ $p->periode }}  @if( Session::get('periode') == $p->periode) selected="selected" @endif>{{ $p->periode }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <br>
                                            <button class="btn btn-info pull-lefts">Cari</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>


            <div class="table-responsive mb-4">
                <table id="datatable" class="table data-table table-hover" style="width:100%">
                    <thead>
                        <tr>
                            @php
                                $no = 1;
                            @endphp
                            <th>No.</th>
                            <th style="text-align: left">Judul</th>
                            <th style="text-align: left">Peneliti</th>
                            <th style="text-align: left">Tahun</th>
                            <th style="text-align: left">Reviewer</th>
                            <th style="text-align: left">Klasifikasi</th>
                            <th style="text-align: left">Kategori</th>
                        </tr>
                    </thead>
                    <tbody>
                        @if($pengusul->isNotEmpty())
                            @foreach($pengusul as $item)
                                <tr>
                                    <td>{{ $no }}</td>
                                    <td style="text-align: left">{{ $item->judul }}</td>
                                    {{-- <td style="text-align: left">{{ $item->peneliti_utama }}</td> --}}
                                    <td style="text-align: left">{{ $item->ketua }}</td>
                                    <td style="text-align: left">{{ date('Y',strtotime($item->tanggal_keputusan)) }}</td>
                                    {{-- @php
                                        $penelaah = DB::table('bantuan_penelaah')->where('id_pengajuan', $item->id_pengajuan)->get();
                                    @endphp --}}
                                    <td style="text-align: left">
                                    {{-- @foreach($penelaah as $p)
                                        {{ $p->penelaah.";" }}<br><br>
                                    @endforeach --}}
                                        @foreach ($item->penelaah as $rev)
                                            {{ $rev->penelaah.";" }}<br><br>
                                        @endforeach
                                    </td>
                                    <td style="text-align: left">{{ $item->klasifikasi }}</td>
                                    @php
                                        $pengajuan = DB::table('tr_pengajuan')->where('id_pengajuan',$item->id_pengajuan)->first();
                                    @endphp
                                    @if(empty($pengajuan))
                                    <td>
                                        <button type="button" class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#updateKategoriModal{{ $item->id_pengajuan }}"><i data-feather='edit'></i></button>
                                    </td>
                                    @else
                                        @php
                                            $kat = DB::table('ms_kategori')->where('id',$pengajuan->id_kategori)->first();
                                        @endphp
                                    <td style="text-align: left">{{ $kat->nama_kategori }}</td>
                                    @endif
                                </tr>

                    <!-- edit registrasi modal -->
                    <div class="modal fade" id="updateKategoriModal{{ $item->id_pengajuan }}" tabindex="-1" aria-labelledby="updateKategori" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <form method="POST" action="{{ route('transaksi.store') }}" enctype="multipart/form-data" id="registrasi">
                                    @csrf
                                <div class="modal-header bg-transparent">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body pb-5 px-sm-4 mx-50">
                                    <h1 class="address-title text-center mb-1" id="addNewAddressTitle">Update Kategori Peneliti</h1>
                                        <div class="row">
                                            <input type="hidden" name="idpengajuan" value="{{ $item->id_pengajuan }}">
                                            <div class="col-md-12">
                                                <label class="form-label" for="judul">Judul</label>
                                                <input type="textarea" class="form-control" id="judul" name="judul" value="{{ $item->judul }}" readonly />
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label" for="peneliti">Peneliti</label>
                                                {{-- <input type="text" class="form-control" id="peneliti" name="peneliti" value="{{ $item->peneliti_utama }}" readonly /> --}}
                                                <input type="text" class="form-control" id="peneliti" name="peneliti" value="{{ $item->ketua }}" readonly />

                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="tahun">Tahun</label>
                                                <input type="text" class="form-control" id="tahun" name="tahun" value="{{ date('Y',strtotime($item->tanggal_keputusan)) }}" readonly />
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="klasifikasi">Klasifikasi</label>
                                                <input type="text" class="form-control" id="klasifikasi" name="klasifikasi" value="{{ $item->klasifikasi }}" readonly />
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="kategori">Kategori Peneliti</label>
                                                <select class="form-control" id="kategori" name="kategori" data-msg="Pilih Kategori Yang Sesuai">
                                                    <option value="">Pilih Kategori</option>
                                                    @foreach($kategori as $k)
                                                        <option value="{{ $k->id }}">{{ $k->kode_kategori }} - {{ $k->nama_kategori }}</option>
                                                    @endforeach
                                                </select>
                                                @if ($errors->has('kategori'))
                                                    <label id="login-error" class="error" for="kategori" style="color: red">{{$errors->first('kategori')}}</label>
                                                @endif
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="file_ec">File EC</label>
                                                <input type="file" class="form-control" id="file_ec" name="file_ec" required>
                                                @if ($errors->has('file_ec'))
                                                    <label id="login-error" class="error" for="file_ec" style="color: red">{{$errors->first('file_ec')}}</label>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label class="form-label" for="nosurat">No Surat E-Office</label>
                                            <input type="text" class="form-control" id="nosurat" name="nosurat" placeholder="Nomor Surat" data-msg="Masukkan Nomor Surat" value="" required />
                                            @if ($errors->has('nosurat'))
                                                <label id="login-error" class="error" for="nosurat" style="color: red">{{$errors->first('nosurat')}}</label>
                                            @endif
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary me-1 mt-2">Simpan</button>
                                            <button type="reset" class="btn btn-outline-secondary mt-2" data-bs-dismiss="modal" aria-label="Close">
                                                Batalkan
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    @php
                        $no++;
                    @endphp
                    <!-- / edit registrasi modal -->
                    @endforeach
                @else
                    <td colspan="7" style="text-align: center">Data tidak ditemukan.</td>
                @endif
            </tbody>
        </table>
            </div>
        </div>
    </div>
    </div>
</div>
@push('js')
<!-- Include DataTable JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/feather-icons"></script>
<script>
    $(document).ready(function() {
        $('#datatable').DataTable();
    });

    feather.replace();
</script>
@endpush
@stop
