@extends('layouts.master')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="card">
        <div class="row layout-top-spacing" id="cancel-row">
            <h5 class="card-header" style="padding-left: 35px">Daftar User</h5>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3" style="padding-left: 30px">
                        <button type="button" class="btn btn-primary text-right" data-bs-toggle="modal" data-bs-target="#addNewUserModal" >
                            Tambah User Admin
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive text-nowrap">
                    <table class="table">
                      <thead class="table-light" align="center">
                        <tr>
                          <th>No.</th>
                          <th>Nama</th>
                          <th>Email</th>
                          <th>Aksi</th>
                        </tr>
                      </thead>
                      <tbody class="table-border-bottom-0">
                          @php
                              $no = 1;
                          @endphp
                          @foreach ($user as $data)
                            <tr style="text-align: center">
                                <td>{{ $no }}</td>
                                <td>{{ $data->name }}</td>
                                <td>{{ $data->email }}</td>
                                <td>
                                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editUserModal{{$data->id}}">Edit</button>
                                    <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteUserModal{{$data->id}}">Hapus</button>
                                </td>
                            </tr>

                            <!-- Modal Update User -->
                            <div class="modal fade" id="editUserModal{{$data->id}}" tabindex="-1" aria-labelledby="tambahAntrian" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <form method="POST" action="{{ route('user.update', ['user' => encrypt($data->id)]) }}" enctype="multipart/form-data" id="registrasi">
                                        @method('PUT')
                                        @csrf
                                    <div class="modal-header">
                                        <h1 class="address-title text-center mb-1" id="addNewUserTitle">Edit User</h1>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label class="form-label" for="name">Nama</label>
                                                <input type="text" class="form-control" id="name" name="name" placeholder="Nama" data-msg="Masukkan Nama" value="{{$data->name}}" required />
                                                @if ($errors->has('name'))
                                                    <label id="login-error" class="error" for="name" style="color: red">{{$errors->first('name')}}</label>
                                                @endif
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label" for="email">Email</label>
                                                <input type="email" id="email" name="email" class="form-control" placeholder="Email" data-msg="Masukkan Email" value="{{$data->email}}" required />
                                                @if ($errors->has('email'))
                                                    <label id="login-error" class="error" for="email" style="color: red">{{$errors->first('email')}}</label>
                                                @endif
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label class="form-label" for="passwordlama">Password Lama</label>
                                                <input type="password" id="passwordlama" name="passwordlama" class="form-control" placeholder="Password Lama" data-msg="Masukkan Password Lama" required />
                                                @if ($errors->has('passwordlama'))
                                                    <label id="login-error" class="error" for="passwordlama" style="color: red">{{$errors->first('passwordlama')}}</label>
                                                @endif
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label" for="passwordbaru">Password Baru</label>
                                                <input type="password" id="passwordbaru" name="passwordbaru" class="form-control" placeholder="Password Baru" data-msg="Masukkan Password Baru" required />
                                                @if ($errors->has('passwordbaru'))
                                                    <label id="login-error" class="error" for="passwordbaru" style="color: red">{{$errors->first('passwordbaru')}}</label>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                                    </div>
                                    </form>
                                </div>
                                </div>
                            </div>
                            <!-- End Modal Update User -->

                            <!-- Modal Delete User -->
                            <div class="modal fade" id="deleteUserModal{{$data->id}}" tabindex="-1" aria-labelledby="tambahAntrian" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <form method="POST" action="{{ route('user.destroy', ['user' => encrypt($data->id) ]) }}" enctype="multipart/form-data">
                                        @csrf
                                        @method("DELETE")
                                        <div class="modal-header">
                                            <h1 class="address-title text-center mb-1" id="addNewUserTitle">Hapus User</h1>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group" style="text-align: center">
                                                <h5 class="address-title text-center mb-3 mt-1" id="addNewAddressTitle">Apakah anda yakin ingin menghapus User ini?</h5>
                                            </div>
                                            <div class="form-group" style="text-align: center">
                                                <button type="submit" class="btn btn-primary ml-1">Delete</button>
                                                <button type="reset" class="btn btn-outline-secondary"  data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                </div>
                            </div>
                            <!-- End Modal Delete User -->
                            @php
                                $no++;
                            @endphp
                          @endforeach
                      </tbody>
                    </table>
                  </div>
            </div>
        </div>
    </div>

    <!-- Modal Tambah User -->
    <div class="modal fade" id="addNewUserModal" tabindex="-1" aria-labelledby="tambahAntrian" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
            <form method="POST" action="{{ route('user.store') }}" enctype="multipart/form-data" id="registrasi">
                @csrf
            <div class="modal-header">
                <h1 class="address-title text-center mb-1" id="addNewUserTitle">Tambah User</h1>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <label class="form-label" for="name">Nama</label>
                        <input type="text" class="form-control" id="name" name="name" placeholder="Nama" data-msg="Masukkan Nama" value="" required />
                        @if ($errors->has('name'))
                            <label id="login-error" class="error" for="name" style="color: red">{{$errors->first('name')}}</label>
                        @endif
                    </div>
                    <div class="col-md-12">
                        <label class="form-label" for="email">Email</label>
                        <input type="email" id="email" name="email" class="form-control" placeholder="Email" data-msg="Masukkan Email" value="" required />
                        @if ($errors->has('email'))
                            <label id="login-error" class="error" for="email" style="color: red">{{$errors->first('email')}}</label>
                        @endif
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <label class="form-label" for="password">Password Baru</label>
                        <input type="password" id="password" name="password" class="form-control" placeholder="Password" data-msg="Masukkan Password" required />
                        @if ($errors->has('password'))
                            <label id="login-error" class="error" for="password" style="color: red">{{$errors->first('password')}}</label>
                        @endif
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Submit</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
            </div>
            </form>
          </div>
        </div>
      </div>
    <!-- End Modal Tambah User -->
</div>
@endsection
@push('js')
@endpush
