<?php

namespace App\Models\Admin;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MsKategori extends Model
{
    use HasFactory;
    use Uuid;

    public $incrementing = false;
    protected $table = 'ms_kategori';
    protected $keyType = 'string';

    protected $fillable = [
        'id',
        'kode_kategori',
        'nama_kategori',
        'poin_saku',
        'status'
    ];

    public function rKategori(){
        return $this->belongsToMany(Pengajuan::class, 'id', 'id_kategori');
    }
}
