@extends('layouts.master')
@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">SAKU Reviewer</h4>
                <form action="{{ route('laporan.download') }}" method="POST">
                    @csrf
                    <button type="submit" class="btn btn-success pull-lefts">Download Excel</button>
                </form>
            </div>
            <div class="card-body">
                <div class="card-text">
                    <div class="row">
                        <div class="panel panel-info">
                            <div class="panel-body">
                                <form action="{{ route('laporan.index') }}" method="GET">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>Periode</label>
                                            <select name="periode" class="form-control">
                                                @foreach($periode as $p)
                                                <option value={{ $p->periode }}  @if( Session::get('periode') == $p->periode) selected="selected" @endif>{{ $p->periode }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <br>
                                            <button class="btn btn-info pull-lefts">Cari</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div><br>
            

            <div class="table-responsive mb-4">
                <table id="zero-config" class="table table-hover" style="width:100%">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th style="text-align: left">Nama Penelaah</th>
                            <th style="text-align: left">NIP</th>
                            <th style="text-align: left">Unit Kerja</th>
                            <th style="text-align: left">Jumlah Protokol yang Ditelaah</th> 
                        </tr>
                    </thead>
                    <tbody>
                        @if($rs->isNotEmpty())
                            @php
                                $no = 1;
                            @endphp
                            @foreach($rs as $item)
                                <tr>
                                    <td>{{ $no }}</td>
                                    <td style="text-align: left">{{ $item->nama }}</td>
                                    <td style="text-align: left">{{ $item->nip }}</td>
                                    <td style="text-align: left">{{ $item->unit }}</td>
                                    <td style="text-align: left">{{ $item->jumlah }}</td>
                                </tr>
                                @php
                                    $no++;
                                @endphp
                            @endforeach
                        @else
                            <td colspan="5" style="text-align: center">Data tidak ditemukan.</td>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
        </div>
    </div>
</div>
@push('js')
@endpush
@stop
