<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Pengajuan;
use App\Models\VPengusul;
use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Middleware;
use Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Session;

class SakuController extends Controller
{

    public function index(Request $request) {
        // $penelaah = DB::table('tr_penelaah')->orderBy('id_pengajuan')->get();

        $filter_periode = DB::table('ms_periode')->orderBy('periode','asc')->get();

        Session::put('periode', $request->periode);

        if(empty(Session::get('periode'))) {
            $periode = DB::table('ms_periode')->where('is_aktif', 1)->first();
            Session::put('periode', $periode->periode);
        } else {
            $periode = DB::table('ms_periode')->where('periode', Session::get('periode'))->first();
        }


        $idPengajuan = VPengusul::whereBetween('tanggal_keputusan', [
        $periode->tanggal_awal,
        $periode->tanggal_akhir
        ])
        ->pluck('id_pengajuan');

        $penelaah = DB::table('tr_penelaah')
                ->select(
                    'tr_penelaah.*',
                    'tr_pengajuan.id_pengajuan as id_pengajuan_epk',
                    'tr_pengajuan.no_sk',
                    'tr_pengajuan.judul',
                    'tr_pengajuan.peneliti',
                    'tr_pengajuan.tahun',
                    'tr_pengajuan.klasifikasi',
                    'tr_pengajuan.file_ec',
                    'ms_kategori.nama_kategori'
                )
                ->join('tr_pengajuan', 'tr_pengajuan.id', '=', 'tr_penelaah.id_pengajuan')
                ->join('ms_kategori', 'ms_kategori.id', '=', 'tr_pengajuan.id_kategori')
                ->whereIn('tr_pengajuan.id_pengajuan', $idPengajuan)
                ->orderBy('id_pengajuan')
                ->get();

        $data = [
            'penelaah' => $penelaah,
            'periode'  => $filter_periode
        ];

        return view('saku.index', $data);
    }

    public function getFileName($tahun, $nosurat){
        // $client = new Client();

        // $response = $client->request('GET', 'https://e-office.unesa.ac.id/api/show-surat-keluar/'.$tahun.'/'.$nosurat);
        // $data = json_decode($response->getBody(), true);

        // if (is_null($data)) {
        //     $namafile = '';
        // }
        // if (empty($data)) {
        //     $namafile = '';
        // }
        // else{
        //     $namafile = $data['namafile'];
        // }

        // return $namafile;

        // Buat handler stack untuk Guzzle
        $handlerStack = HandlerStack::create();

        // Tambahkan retry middleware
        $handlerStack->push(Middleware::retry(
            function ($retries, $request, $response, $exception) {
                // Maksimum 3 kali percobaan ulang
                if ($retries >= 3) {
                    return false;
                }

                // Jika response 429 (Too Many Requests), retry
                if ($response && $response->getStatusCode() == 429) {
                    return true;
                }

                return false;
            },
            function ($retries) {
                // jeda 1s, 2s, 3s...
                return 1000 * $retries;
            }
        ));

        // Inisialisasi client
        $client = new Client([
            'handler' => $handlerStack,
            'timeout' => 10, // optional: timeout tiap request
        ]);

        try {
            $response = $client->request('GET', "https://e-office.unesa.ac.id/api/show-surat-keluar/{$tahun}/{$nosurat}");
            $data = json_decode($response->getBody(), true);

            if (empty($data) || is_null($data)) {
                $namafile = '';
            } else {
                $namafile = $data['namafile'] ?? '';
            }

        } catch (RequestException $e) {
            // Tangani jika gagal total (misal setelah 3 retry)
            $namafile = '';
            // Opsional: tulis log error
            Log::error("Gagal ambil surat keluar: ".$e->getMessage());
        }

        return $namafile;

    }
}
