@extends('layouts.master')
@section('content')
<div class="row match-height">
    <div class="col-lg-4 col-md-6 col-12">
        <div class="card card-developer-meetup">
            <div class="meetup-img-wrapper rounded-top text-center">
                <img src="{{ url('theme/images/illustration/email.svg') }}" alt="Meeting Pic" height="170" />
            </div>
            <div class="card-body">
                <div class="meetup-header d-flex align-items-center">
                    <div class="meetup-day">
                        <h6 class="mb-0">{{ Carbon\Carbon::now()->isoFormat('dddd'); }}</h6>
                        <h3 class="mb-0">{{ Carbon\Carbon::now()->isoFormat('D'); }}</h3>
                        <h6 class="mb-0">{{ Carbon\Carbon::now()->isoFormat('MMM Y'); }}</h6>
                    </div>
                    <div class="my-auto">
                        <h4 class="card-title mb-25">SIPEKA (Sistem Informasi Penelaah Etik Penelitian LPPM Unesa)</h4>
                    </div>
                </div>

                <div class="mt-2">
                    <div class="avatar float-start bg-light-primary rounded me-1">
                        <div class="avatar-content">
                            <i data-feather="map-pin" class="avatar-icon font-medium-3"></i>
                        </div>
                    </div>
                    <div class="more-info">
                        <h6 class="mb-0">Universitas Negeri Surabaya</h6>
                        <small>Lidah Wetan, Surabaya</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-8 col-12">
        <div class="card card-statistics">
            <div class="card-header">
                <h4 class="card-title">Pengusul</h4>
            </div>
                <div class="card-body statistics-body">
                    <div class="row">
                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-primary me-2">
                                    <div class="avatar-content">
                                        <i data-feather='users' class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    @php
                                        if(isset($jumlah['c6c43201-3f60-43af-968a-75c2984624e7'])){
                                            $jsarjana = $jumlah['c6c43201-3f60-43af-968a-75c2984624e7'];
                                        } else {
                                            $jsarjana = 0;
                                        }
                                    @endphp
                                        <h4 class="fw-bolder mb-0">{{ $jsarjana }}</h4>
                                        <p class="card-text font-small-3 mb-0">Mhs S1/D4 Unesa</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-primary me-2">
                                    <div class="avatar-content">
                                        <i data-feather="users" class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    @php
                                        if(isset($jumlah['e38b64e5-4bc8-49fc-999b-bf4cb6052236'])){
                                            $jsarjanaluar = $jumlah['e38b64e5-4bc8-49fc-999b-bf4cb6052236'];
                                        } else {
                                            $jsarjanaluar = 0;
                                        }
                                    @endphp
                                        <h4 class="fw-bolder mb-0">{{ $jsarjanaluar }}</h4>
                                        <p class="card-text font-small-3 mb-0">Mhs S1/D4 Luar</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-info me-2">
                                    <div class="avatar-content">
                                        <i data-feather='users' class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    @php
                                        if(isset($jumlah['11459605-89b4-4dfc-9586-519802e989e4'])){
                                            $jpasca = $jumlah['11459605-89b4-4dfc-9586-519802e989e4'];
                                        } else {
                                            $jpasca = 0;
                                        }
                                    @endphp
                                        <h4 class="fw-bolder mb-0">{{ $jpasca }}</h4>
                                        <p class="card-text font-small-3 mb-0">Mhs S2/S3 Unesa</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-info me-2">
                                    <div class="avatar-content">
                                        <i data-feather="users" class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    @php
                                        if(isset($jumlah['81814ab3-299d-42c2-aa49-9f3c80d887ca'])){
                                            $jpascaluar = $jumlah['81814ab3-299d-42c2-aa49-9f3c80d887ca'];
                                        } else {
                                            $jpascaluar = 0;
                                        }
                                    @endphp
                                        <h4 class="fw-bolder mb-0">{{ $jpascaluar }}</h4>
                                        <p class="card-text font-small-3 mb-0">Mhs S2/S3 Luar</p>
                                </div>
                            </div>
                        </div>
                    </div><br>
                    <div class="row">
                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-success me-2">
                                    <div class="avatar-content">
                                        <i data-feather='users' class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    @php
                                        if(isset($jumlah['ec949871-68fa-4357-8084-547db716faf6'])){
                                            $jdosen = $jumlah['ec949871-68fa-4357-8084-547db716faf6'];
                                        } else {
                                            $jdosen = 0;
                                        }
                                    @endphp
                                        <h4 class="fw-bolder mb-0">{{ $jdosen }}</h4>
                                        <p class="card-text font-small-3 mb-0">Dosen Unesa</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6 col-12 mb-2 mb-xl-0">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-success me-2">
                                    <div class="avatar-content">
                                        <i data-feather="users" class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    @php
                                        if(isset($jumlah['53aff26e-c76f-4b7a-b7c5-88d31afe5880'])){
                                            $jdosenluar = $jumlah['53aff26e-c76f-4b7a-b7c5-88d31afe5880'];
                                        } else {
                                            $jdosenluar = 0;
                                        }
                                    @endphp
                                        <h4 class="fw-bolder mb-0">{{ $jdosenluar }}</h4>
                                        <p class="card-text font-small-3 mb-0">Dosen Luar</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6 col-12">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-danger me-2">
                                    <div class="avatar-content">
                                        <i data-feather="users" class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    @php
                                        if(isset($jumlah['790fdbb1-36e7-447c-9a38-55b62816395c'])){
                                            $jindustri = $jumlah['790fdbb1-36e7-447c-9a38-55b62816395c'];
                                        } else {
                                            $jindustri = 0;
                                        }
                                    @endphp
                                    <h4 class="fw-bolder mb-0">{{ $jindustri }}</h4>
                                    <p class="card-text font-small-3 mb-0">Industri</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-header">
                    <h4 class="card-title">Kategori</h4>
                </div>
                <div class="card-body statistics-body">
                    <div class="row">
                        <div class="col-xl-6 col-sm-6 col-12 mb-2 mb-xl-0">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-warning me-2">
                                    <div class="avatar-content">
                                        <i data-feather='clipboard' class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    <h4 class="fw-bolder mb-0">{{ $sudah }}</h4>
                                    <p class="card-text font-small-3 mb-0">Sudah dikategorikan</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-sm-6 col-12 mb-2 mb-xl-0">
                            <div class="d-flex flex-row">
                                <div class="avatar bg-light-secondary me-2">
                                    <div class="avatar-content">
                                        <i data-feather="clipboard" class="avatar-icon"></i>
                                    </div>
                                </div>
                                <div class="my-auto">
                                    <h4 class="fw-bolder mb-0">{{ $belum }}</h4>
                                    <p class="card-text font-small-3 mb-0">Belum dikategorikan</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
    </div>
</div>
@stop
