<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Support\ValidationRule;
use App\Models\Admin\MsKategori;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redirect;

class KategoriController extends Controller
{
    public function index() {
        $kategori = MsKategori::query()->get();

        $data = [
            'kategori' => $kategori
        ];

        return view('Admin.Kategori.index', $data);
    }

    public function store(Request $request){
        $rule = [
            'kodekategori' => 'required|string',
            'namakategori' => 'required|string',
            // 'poinsaku' => 'required|string'
        ];

        $request->validate($rule, ValidationRule::getErrorMessage($rule));

        DB::beginTransaction();

        try{
            $kategori = [
                'kode_kategori' => strip_tags($request->kodekategori),
                'nama_kategori' => strip_tags($request->namakategori),
                // 'poin_saku' => strip_tags($request->poinsaku),
                'status' => $request->status
            ];

            MsKategori::query()->create($kategori);

            DB::commit();

            return Redirect::route('kategori.index')
                ->with('success', 'Data kategori berhasil ditambahkan');
        }
        catch(Exception $e){
            Log::error($e);
            DB::rollBack();

            return Redirect::route('kategori.index')
                ->with('error', 'Data kategori gagal ditambahkan');
        }
    }

    public function update(Request $request, $id){
        $rule = [
            'kodekategori' => 'required|string',
            'namakategori' => 'required|string',
            // 'poinsaku' => 'required|string'
        ];

        $request->validate($rule, ValidationRule::getErrorMessage($rule));

        DB::beginTransaction();

        try{
            $id = decrypt($id);

            $kategori = [
                'kode_kategori' => strip_tags($request->kodekategori),
                'nama_kategori' => strip_tags($request->namakategori),
                // 'poin_saku' => strip_tags($request->poinsaku),
                'status' => $request->status
            ];

            MsKategori::where('id', $id)->update($kategori);

            DB::commit();

            return Redirect::route('kategori.index')
                ->with('success', 'Data kategori berhasil diupdate');
        }
        catch(Exception $e){
            Log::error($e);
            DB::rollBack();

            return Redirect::route('kategori.index')
                ->with('error', 'Data kategori gagal diupdate');
        }
    }

    public function destroy($id) {
        $id = decrypt($id);

        DB::beginTransaction();

        try{
            MsKategori::where('id', $id)->delete();

            DB::commit();

            return Redirect::route('kategori.index')
                ->with('success', 'Data kategori berhasil dihapus');
        }
        catch(Exception $e){
            Log::error($e);
            DB::rollBack();

            return Redirect::route('kategori.index')
                ->with('error', 'Data kategori gagal dihapus');
        }
    }
}
