<?php

namespace App\Http\Controllers\Admin;

use App\Http\Support\ValidationRule;
use App\Http\Controllers\Controller;
use App\Models\Admin\Penelaah;
use App\Models\Admin\Pengajuan;
use App\Models\VPenelaah;
use App\Models\VPengusul;
use Exception;
use Storage;
use Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redirect;

class TransaksiController extends Controller
{

    public function index(Request $request) {

        $filter_periode = DB::table('ms_periode')->orderBy('periode','asc')->get();

        Session::put('status', $request->status);
        Session::put('periode', $request->periode);

        if(empty(Session::get('status'))) {
            if(empty(Session::get('periode'))){
                $periode = DB::table('ms_periode')->where('is_aktif', 1)->first();
                Session::put('periode', $periode->periode);

            } else {
                $periode = DB::table('ms_periode')->where('periode', Session::get('periode'))->first();
            }

            // v0
            // $pengusul = DB::table('bantuan_pengusul')
            //     ->whereBetween('tanggal_keputusan', [$periode->tanggal_awal, $periode->tanggal_akhir])
            //     ->get();

            // v1
            $pengusul = VPengusul::with('penelaah')
            ->whereBetween('tanggal_keputusan', [$periode->tanggal_awal, $periode->tanggal_akhir])
            ->get();

        } else {

            $pengajuan = DB::table('tr_pengajuan')->select('id_pengajuan')->get();

            foreach($pengajuan as $p){
                $list[$p->id_pengajuan] = $p->id_pengajuan;
            }

            if(Session::get('status') == '1'){

                if(empty(Session::get('periode'))){
                    $periode = DB::table('ms_periode')->where('is_aktif', 1)->first();
                    Session::put('periode', $periode->periode);
                } else {
                    $periode = DB::table('ms_periode')->where('periode', Session::get('periode'))->first();
                }

                // v0
                // $pengusul = DB::table('bantuan_pengusul')
                // ->whereIn('id_pengajuan',$list)
                // ->whereBetween('tanggal_keputusan', [$periode->tanggal_awal, $periode->tanggal_akhir])
                // ->get();

                // v1
                $pengusul = VPengusul::with('penelaah')
                ->whereIn('id_pengajuan', $list)
                ->whereBetween('tanggal_keputusan', [$periode->tanggal_awal, $periode->tanggal_akhir])
                ->get();

            }elseif(Session::get('status') == '2'){
                if(empty(Session::get('periode'))){
                    $periode = DB::table('ms_periode')->where('is_aktif', 1)->first();
                    Session::put('periode', $periode->periode);
                } else {
                    $periode = DB::table('ms_periode')->where('periode', Session::get('periode'))->first();
                }

                // v0
                // $pengusul = DB::table('bantuan_pengusul')
                //     ->whereNotIn('id_pengajuan',$list)
                //     ->whereBetween('tanggal_keputusan', [$periode->tanggal_awal, $periode->tanggal_akhir])
                //     ->get();

                // v1
                $pengusul = VPengusul::with('penelaah')
                ->whereNotIn('id_pengajuan',$list)
                ->whereBetween('tanggal_keputusan', [$periode->tanggal_awal, $periode->tanggal_akhir])
                ->get();

            }

        }

        $kategori = DB::table('ms_kategori')->orderBy('kode_kategori','asc')->get();

        $data = [
            'pengusul' => $pengusul,
            'kategori' => $kategori,
            'periode'  => $filter_periode
        ];

        return view('transaksi.index', $data);
    }

    public function store(Request $request){

        $rule = [
            'kategori' => 'required',
            'file_ec' => 'required|mimes:pdf|max:3072',
            'nosurat' => 'required'
        ];

        $request->validate($rule, ValidationRule::getErrorMessage($rule));

        DB::beginTransaction();

        try{

            if($request->hasFile('file_ec')){
                $file = $request->file('file_ec');
                $filename = $file->getClientOriginalName();

                $path_dir = 'sipeka/file/';
                $move = $request->file('file_ec')->move($path_dir,$filename);

                // $cek = Storage::disk('uploads')->put('sipeka/'.$filename, file_get_contents($file->getRealPath()));
                // dd($cek);
            }

                $transaksi = [
                    'id_pengajuan' => $request->idpengajuan,
                    'judul' => $request->judul,
                    'peneliti' => $request->peneliti,
                    'klasifikasi' => $request->klasifikasi,
                    'tahun' => $request->tahun,
                    'id_kategori' => $request->kategori,
                    'file_ec' => $filename,
                    'no_sk' => $request->nosurat,
                ];

                $hasil = Pengajuan::query()->create($transaksi);

                // $hasil = DB::table('tr_pengajuan')->where('id_pengajuan',$request->idpengajuan)->first();

                // v0
                // $reviewer = DB::table('bantuan_penelaah')->where('id_pengajuan',$request->idpengajuan)->pluck('nik');

                // v1
                $reviewer = VPenelaah::where('id_pengajuan', $request->idpengajuan)->pluck('nik');

                $count = DB::connection('isdm')->table('v_detil_pegawai')->whereIn('noktp',$reviewer)->select('noktp')->get();

                if(count($count) >= 2){
                    foreach($count as $sdm){
                        $isdm = DB::connection('isdm')->table('v_detil_pegawai')->where('noktp',$sdm->noktp)->select('namalengkap','nip','namaparentsatker')->first();

                        $saku = [
                                'id_pengajuan' => $hasil->id,
                                'nik' => $sdm->noktp,
                                'nama' => $isdm->namalengkap,
                                'nip' => $isdm->nip,
                                'unit' => $isdm->namaparentsatker
                        ];

                        Penelaah::query()->create($saku);
                    }


                } else {
                    foreach($count as $sdm){
                        $data['kosong'] = VPenelaah::where('id_pengajuan',$request->idpengajuan)->where('nik','!=', $sdm->noktp)->first();
                    }

                    return view('transaksi-gagal', $data);
                }

                DB::commit();

                return Redirect::route('transaksi.index')
                ->with('success', 'Data kategori berhasil diupdate');
        }
        catch(Exception $e){
            Log::error($e);
            DB::rollBack();

            return Redirect::route('transaksi.index')
            ->with('error', 'Data Kategori gagal diupdate');
        }
    }
}
