<?php

namespace App\Models\Admin;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Penelaah extends Model
{
    use HasFactory;
    use Uuid;

    public $incrementing = false;
    protected $table = 'tr_penelaah';
    protected $keyType = 'string';

    protected $fillable = [
        'id',
        'id_pengajuan',
        'nik',
        'nama',
        'nip',
        'unit'
    ];

    public function penelaah(){
        return $this->belongsTo(Pengajuan::class, 'id_pengajuan', 'id')->with('kategori');
    }
}
