<?php

namespace App\Models\Admin;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pengajuan extends Model
{
    use HasFactory;
    use Uuid;

    public $incrementing = false;
    protected $table = 'tr_pengajuan';
    protected $keyType = 'string';

    protected $fillable = [
        'id',
        'id_pengajuan',
        'judul',
        'peneliti',
        'klasifikasi',
        'tahun',
        'id_kategori',
        'file_ec',
        'no_sk'
    ];

    public function rPenelaah() {
        return $this->hasOne(Penelaah::class, 'id_pengajuan', 'id');
    }

    public function kategori(){
        return $this->hasOne(MsKategori::class, 'id', 'id_kategori');
    }
}
