@extends('layouts.master')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="card">
        <div class="row layout-top-spacing" id="cancel-row">
            <h5 class="card-header" style="padding-left: 35px">Daftar Periode</h5>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3" style="padding-left: 30px">
                        <button type="button" class="btn btn-primary text-right" data-bs-toggle="modal" data-bs-target="#addNewUserModal" >
                            Tambah Periode
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive text-nowrap">
                    <table class="table">
                      <thead class="table-light" align="center">
                        <tr>
                          <th>No.</th>
                          <th>Periode</th>
                          <th>Tanggal Awal</th>
                          <th>Tanggal Akhir</th>
                          <th>Status AKTIF</th>
                          <th>Aksi</th>
                        </tr>
                      </thead>
                      <tbody class="table-border-bottom-0">
                          @php
                              $no = 1;
                          @endphp
                          @foreach ($periode as $data)
                            <tr style="text-align: center">
                                <td>{{ $no }}</td>
                                <td>{{ $data->periode }}</td>
                                <td>{{ $data->tanggal_awal }}</td>
                                <td>{{ $data->tanggal_akhir }}</td>
                                @if($data->is_aktif == 1)
                                <td>Aktif</td>
                                @else
                                <td>Tidak Aktif</td>
                                @endif
                                <td>
                                    <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editUserModal{{$data->periode}}">Edit</button>
                                    {{-- <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteUserModal{{$data->id}}">Hapus</button> --}}
                                </td>
                            </tr>

                            <!-- Modal Update User -->
                            <div class="modal fade" id="editUserModal{{$data->periode}}" tabindex="-1" aria-labelledby="tambahAntrian" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <form method="POST" action="{{ route('periode.update', ['periode' => encrypt($data->periode)]) }}" enctype="multipart/form-data" id="registrasi">
                                        @method('PUT')
                                        @csrf
                                    <div class="modal-header">
                                        <h1 class="address-title text-center mb-1" id="addNewUserTitle">Edit Periode</h1>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label class="form-label" for="periode">Nama Periode</label>
                                                <input type="number" class="form-control" id="periode" name="periode" placeholder="Periode" data-msg="Masukkan Periode" value="{{$data->periode}}" readonly/>
                                                @if ($errors->has('periode'))
                                                    <label id="login-error" class="error" for="periode" style="color: red">{{$errors->first('periode')}}</label>
                                                @endif
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label" for="tanggal_awal">Tanggal Awal</label>
                                                <input type="date" id="tanggal_awal" name="tanggal_awal" class="form-control" placeholder="Tanggal Awal" data-msg="Masukkan Tanggal" value="{{$data->tanggal_awal}}" required />
                                                @if ($errors->has('tanggal_awal'))
                                                    <label id="login-error" class="error" for="tanggal_awal" style="color: red">{{$errors->first('tanggal_awal')}}</label>
                                                @endif
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label" for="tanggal_awal">Tanggal Akhir</label>
                                                <input type="date" id="tanggal_akhir" name="tanggal_akhir" class="form-control" placeholder="Tanggal Akhir" data-msg="Masukkan Tanggal" value="{{$data->tanggal_akhir}}" required />
                                                @if ($errors->has('tanggal_akhir'))
                                                    <label id="login-error" class="error" for="tanggal_akhir" style="color: red">{{$errors->first('tanggal_akhir')}}</label>
                                                @endif
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label class="form-label" for="is_aktif">Status</label>
                                                <select id="is_aktif" name="is_aktif" class="form-control" required>
                                                    <option value="">Pilih</option>
                                                    <option value="1" {{ old('is_aktif', $data->is_aktif) == '1' ? 'selected' : '' }}>Aktif</option>
                                                    <option value="2" {{ old('is_aktif', $data->is_aktif) == '2' ? 'selected' : '' }}>Tidak Aktif</option>
                                                </select>
                                                @if ($errors->has('is_aktif'))
                                                    <label id="login-error" class="error" for="is_aktif" style="color: red">{{$errors->first('is_aktif')}}</label>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
                                    </div>
                                    </form>
                                </div>
                                </div>
                            </div>
                            <!-- End Modal Update User -->
                            @php
                                $no++;
                            @endphp
                          @endforeach
                      </tbody>
                    </table>
                  </div>
            </div>
        </div>
    </div>

    <!-- Modal Tambah User -->
    <div class="modal fade" id="addNewUserModal" tabindex="-1" aria-labelledby="tambahAntrian" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content">
            <form method="POST" action="{{ route('periode.store') }}" enctype="multipart/form-data" id="registrasi">
                @csrf
            <div class="modal-header">
                <h1 class="address-title text-center mb-1" id="addNewUserTitle">Tambah Periode</h1>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <label class="form-label" for="periode">Nama Periode</label>
                        <input type="number" class="form-control" id="periode" name="periode" placeholder="Periode" data-msg="Masukkan Periode" value="" required />
                        @if ($errors->has('periode'))
                            <label id="login-error" class="error" for="periode" style="color: red">{{$errors->first('periode')}}</label>
                        @endif
                    </div>
                    <div class="col-md-12">
                        <label class="form-label" for="tanggal_awal">Tanggal Awal</label>
                        <input type="date" id="tanggal_awal" name="tanggal_awal" class="form-control" placeholder="Tanggal Awal" data-msg="Masukkan Tanggal" value="" required />
                        @if ($errors->has('tanggal_awal'))
                            <label id="login-error" class="error" for="tanggal_awal" style="color: red">{{$errors->first('tanggal_awal')}}</label>
                        @endif
                    </div>
                    <div class="col-md-12">
                        <label class="form-label" for="tanggal_akhir">Tanggal Akhir</label>
                        <input type="date" id="tanggal_akhir" name="tanggal_akhir" class="form-control" placeholder="Tanggal Akhir" data-msg="Masukkan Tanggal" value="" required />
                        @if ($errors->has('tanggal_akhir'))
                            <label id="login-error" class="error" for="tanggal_akhir" style="color: red">{{$errors->first('tanggal_akhir')}}</label>
                        @endif
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <label class="form-label" for="is_aktif">Status Aktif</label>
                        <select id="is_aktif" name="is_aktif" class="form-control" required>
                            <option value="">Pilih</option>
                            <option value="1">Aktif</option>
                            <option value="2">Tidak Aktif</option>
                        </select>
                        @if ($errors->has('is_aktif'))
                            <label id="login-error" class="error" for="is_aktif" style="color: red">{{$errors->first('is_aktif')}}</label>
                        @endif
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Submit</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">Cancel</button>
            </div>
            </form>
          </div>
        </div>
      </div>
    <!-- End Modal Tambah User -->
</div>
@endsection
@push('js')
@endpush
