<?php

use App\Http\Controllers\Admin\Auth\LoginController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\KategoriController;
use App\Http\Controllers\Admin\LaporanController;
use App\Http\Controllers\Admin\PeriodeController;
use App\Http\Controllers\Admin\TransaksiController;
use App\Http\Controllers\Admin\SakuController;
use App\Http\Controllers\Admin\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('Admin.login');
});

// Route::get('/home', [TransaksiController::class, 'index'])->name('admin.index-transaksi');

Route::middleware(['auth','prevent-back-history'])->group(function(){
    Route::get('/home', [DashboardController::class, 'index']);
    Route::resource('kategori', KategoriController::class);
    Route::resource('transaksi', TransaksiController::class);
    Route::resource('saku', SakuController::class);
    Route::resource('laporan', LaporanController::class);
    Route::post('/excel', [LaporanController::class, 'download'])->name('laporan.download');
    Route::resource('user', UserController::class);
    Route::resource('periode', PeriodeController::class);
    Route::get('/logout', [LoginController::class, 'logout'])->name('admin.logout');
});
