<?php

namespace App\Helpers;

class InseoHelper
{
    public static function tglbulanindo($waktu, $tipe = '')
    {
        $detik = substr($waktu, 17, 2);
        $menit = substr($waktu, 14, 2);
        $jam = substr($waktu, 11, 2);
        $tgl = substr($waktu, 8, 2);
        $bln = substr($waktu, 5, 2);
        $thn = substr($waktu, 0, 4);
        $bulan = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'Nopember', 'Desember'];
        $idxhari = date('N', strtotime($waktu));

        switch ($tipe) {
            case 1:
                $full = $tgl.' '.$bulan[(int) $bln - 1].' '.$thn;
                break;
            case 2:
                $full = $tgl.'/'.$bln.'/'.$thn;
                break;
            case 3:
                $full = $tgl.'/'.$bln.'/'.$thn.' '.$jam.':'.$menit.':'.$detik;
                break;
            default:
                $full = "$tgl ".$bulan[(int) $bln - 1]." $thn";
        }

        return $full;
    }

    public static function singkatan_fakultas()
    {
        $fak = [
        'teknik' => 'FT',
        'fakultas teknik' => 'FT',
        'ft' => 'FT',
        'fak. teknik' => 'FT',

        'ilmu sosial & hukum' => 'FISH',
        'fakultas ilmu sosial & hukum' => 'FISH',
        'fish' => 'FISH',
        'fak. ilmu sosial & hukum' => 'FISH',
        'ilmu sosial dan hukum' => 'FISH',

        'ilmu pendidikan' => 'FIP',
        'fakultas ilmu pendidikan' => 'FIP',
        'fip' => 'FIP',
        'fak. ilmu pendidikan' => 'FIP',

        'bahasa dan seni' => 'FBS',
        'fakultas bahasa dan seni' => 'FBS',
        'fbs' => 'FBS',
        'fak. bahasa dan seni' => 'FBS',

        'matematika dan ilmu pengetahuan alam' => 'FMIPA',
        'fakultas matematika dan ilmu pengetahuan alam' => 'FMIPA',
        'fmipa' => 'FMIPA',
        'fak. matematika dan ilmu pengetahuan alam' => 'FMIPA',

        'ilmu keolahragaan' => 'FIKK',
        'fakultas ilmu keolahragaan' => 'FIKK',
        'fio' => 'FIKK',
        'fak. ilmu keolahragaan' => 'FIKK',
        'ilmu olahraga' => 'FIKK',
        'fakultas ilmu olahraga' => 'FIKK',
        'fiK' => 'FIKK',
        'fak. ilmu olahraga' => 'FIKK',

        'ilmu keolahragaan dan kesehatan' => 'FIKK',

        'ekonomi' => 'FEB',
        'fakultas ekonomi' => 'FEB',
        'fe' => 'FEB',
        'fak. ekonomi' => 'FEB',
        'ekonomika dan bisnis' => 'FEB',

        'vok' => 'VOKASI',
        'vokasi' => 'VOKASI',
        'fakultas vokasi' => 'VOKASI',
        'fak. vokasi' => 'VOKASI',

        'fisipol' => 'FISIPOL',
        'ilmu sosial dan ilmu politik' => 'FISIPOL',

        'kedokteran' => 'FK',

        'psikologi' => 'FP',
        'hukum' => 'FH',
        'ilmu hukum' => 'FH',

        'kampus unesa magetan' => 'PSDKU Magetan',
        ];

        return $fak;
    }

    public static function random_password() {
        $alphabet = '1234567890';
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < 8; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); //turn the array into a string
    }
}
