@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Dosen</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                </div>
            </div>
        </div>

    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr>
                                <th>No</th>
                                <th>Jenis</th>
                                <th>Judul</th>
                                <th>Keterangan</th>
                                <th>File</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach ($proposal->rLuaran as $item)
                                @php $token = Str::random(30); @endphp
                                <tr id="row-{{ $token }}">
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $item->jenis_luaran }}</td>
                                    <td>{{ $item->judul }}</td>
                                    <td>{{ $item->keterangan_luaran }}</td>
                                    <td><a href="https://statik.unesa.ac.id/simpmw/luaran/{{ $item->jenis_luaran }}/{{ $item->file_luaran }}" target="_blank" title="Logbook" class="btn btn-info btn-sm waves-effect waves-light"> <i class="fas fa-search"></i> Lihat</a></td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
    <div id="tmbhKel" class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="{{ route('mahasiswa.luaran.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">Tambah Luaran</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                        <input class="form-control" type="hidden" name="proposal_id" id="proposal_id" value="{{ $proposal->proposal_id }}">
                        <div class="col-12">
                            <h5 class="font-size-16">Jenis Luaran : </h5>
                        <p><select class="form-select" aria-label="Default select example" name="jenis_luaran">
                                <option value="Buku">Buku</option>
                                <option value="Jurnal">Jurnal</option>
                                <option value="Video">Video</option>
                                <option value="Produk">Produk</option>
                                <option value="Media">Publikasi Media</option>
                            </select></p>
                        </div>
                        <div class="col-12">
                            <h5 class="font-size-16">Judul : </h5>
                        <p>
                            <input class="form-control" type="text" name="judul" id="judul">
                        </p>
                        <div class="col-12">
                            <h5 class="font-size-16">Upload File : </h5>
                        <p>
                            <input type="file" name="file" class="form-control" id="input-file">
                        </p>
                        <div class="col-12">
                            <h5 class="font-size-16">Keterangan : </h5>
                        <p>
                            <textarea id="textarea" class="form-control" maxlength="225" rows="3" name="keterangan_luaran" ></textarea>
                        </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary waves-effect waves-light">Save changes</button>
                </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

@endsection

@section('js')
<script>
    function hapus(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menghapus usulan ini?',
            text: "file yang sudah terupload juga terhapus",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('mahasiswa.luaran.hapus') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            title: 'Data Berhasil Di Hapus',
                            icon: 'success',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        $('#'+rowId).remove();
                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }
</script>
@endsection
