@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('mahasiswa.kelompok.store') }}" method="POST">
                        @csrf
                    <h4 class="card-title">Kelompok Baru</h4>
                    <p class="card-title-desc"></p>
                    <div class=" row mb-3">
                        <label class="col-sm-2 col-form-label">Dosen Pembimbing</label>
                        <div class="col-sm-10">
                            <input type="hidden" name="periode" value="{{ $periode['periode_id'] }}" >
                            <select class="form-select" id="selectDosen" name="dosen">

                            </select>
                        </div>
                    </div>
                    <div class="mb-0">
                        <div>
                            <button type="submit" class="btn btn-primary waves-effect waves-light me-1">
                                Submit
                            </button>
                            <button type="reset" class="btn btn-secondary waves-effect">
                                Cancel
                            </button>
                        </div>
                    </div>
                </form>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

@endsection

@section('js')
<script>
     $(document).ready(function() {

        $("#selectDosen").select2({
            ajax: {
                url: "{{ route('api.getDosen') }}",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
                },
                processResults: function (data, params) {
                // parse the results into the format expected by Select2
                // since we are using custom formatting functions we do not need to
                // alter the remote JSON data, except to indicate that infinite
                // scrolling can be used
                params.page = params.page || 1;

                // return {
                //     results: data.items,
                //     pagination: {
                //     more: (params.page * 30) < data.total_count
                //     }
                // };
                // },
                const modifiedItems = data.items.map(item => {
                    return {
                        id: item.id,
                        text: item.full_name,
                        full_name: item.full_name,
                        description: item.description,
                        disabled: item.disabled || false,
                    };
                });

                    return {
                        results: modifiedItems,
                        pagination: {
                            more: (params.page * 30) < data.total_count
                        }
                    };
                },
                cache: true
            },
            placeholder: 'Pilih Dosen Pembimbing',
            minimumInputLength: 1,
            templateResult: formatRepo,
            templateSelection: formatRepoSelection
    });
});

    function formatRepo (repo) {
  if (repo.loading) {
    return repo.text;
  }

  var $container = $(
    "<div class='select2-result-repository clearfix'>" +
      "<div class='select2-result-repository__meta'>" +
        "<div class='select2-result-repository__title'></div>" +
        "<div class='select2-result-repository__description text-muted'></div>" +
      "</div>" +
    "</div>"
  );

  $container.find(".select2-result-repository__title").text(repo.full_name);
  $container.find(".select2-result-repository__description").html(repo.description);

  return $container;
}


function formatRepoSelection (repo) {
  return repo.full_name || repo.text;
}
</script>
@endsection
