@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('mahasiswa.proposal.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                    <h4 class="card-title">{!! $title !!}</h4>
                    <p class="card-title-desc"></p>
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Judul</label>
                        <div class="col-sm-10">
                            <input class="form-control" type="text" id="judul" name="judul" required>
                            <input class="form-control" type="hidden" id="kode_kelompok" name="kode_kelompok" value="{{ $kelompok->kelompok_id }}" >
                            <input class="form-control" type="hidden" id="periode_id" name="periode_id" value="{{ $periode->periode_id }}" >
                        </div>
                    </div>
                    <div class=" row mb-3">
                        <label class="col-sm-2 col-form-label">Kategori PMW</label>
                        <div class="col-sm-10">
                            <select class="form-select select2" name="jenis">
                                <option selected>Pilih Jenis</option>
                                @foreach($jenis as $item => $pkm)
                                    <option value="{{ $item }}">{{ $pkm }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3" class="dropzone">
                        <label for="kode" class="col-sm-2 col-form-label">Upload Proposal</label>
                        <div class="col-sm-10">
                            <input type="file" name="file" class="form-control" id="input-file">
                            <iframe id="view-pdf" width="80%" height="80%" src="" frameborder="0"></iframe>
                        </div>
                    </div>
                    <div class="mb-0">
                        <div>
                            <button type="submit" class="btn btn-primary waves-effect waves-light me-1"> Submit </button>
                            <button type="reset" class="btn btn-secondary waves-effect"> Cancel </button>
                        </div>
                    </div>
                </form>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')

<script>
    $(function(){
        $('#input-file').change(function(){
            var input = this;
            var url = window.URL.createObjectURL(this.files[0]);
            $('#view-pdf').attr('src',url);
            $('#view-pdf').attr('height','500px');
        })
    })
</script>

@endsection
