@extends('layouts.master')

@section('title')
Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
<!-- start page title -->
<div class="page-title-box">
    <div class="row align-items-center">
        <div class="col-md-8">
            <h6 class="page-title">{!! $title !!}</h6>
            <ol class="breadcrumb m-0">
                <li class="breadcrumb-item">Setting</li>
                <li class="breadcrumb-item">{!! $title !!}</li>
            </ol>
        </div>
        <div class="col-md-4">
            <div class="float-end d-none d-md-block">
                <a href="javascript:void(0)" class="btn btn-success waves-effect waves-light" id="btnSimpan"
                    style="display: none" onclick="submitForm()">Simpan Jadwal <i class="fas fa-check-circle"></i></a>
                <button class="btn btn-primary waves-effect waves-light" id="btnEdit"> <i
                        class="fas fa-plus-circle"></i> Edit Jadwal</button>
            </div>
        </div>
    </div>
</div>
<!-- end page title -->

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                {!! Form::open(array('url' => route('operator.jadwal-kegiatan.store'), 'method' => 'POST', 'id' => 'ff', 'class' => 'form-horizontal')) !!}
                {!! csrf_field() !!}
                <div class="table-responsive">
                    <table id="example" class="table table-bordered dt-responsive nowrap"
                        style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                        <thead>
                            <tr>
                                <th>Nama Kegiatan</th>
                                <th style="text-align: center">Tanggal Mulai</th>
                                <th style="text-align: center">Tanggal Selesai</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data['jadwal_kegiatan'] as $item => $val)
                            @php
                                $tgl_awal = Carbon::parse($val->tanggal_mulai)->format('d-m-Y H:i')?:'';
                                $tgl_akhir = Carbon::parse($val->tanggal_selesai)->format('d-m-Y H:i')?:'';

                                $tgl = $tgl_awal.' - '.$tgl_akhir;
                            @endphp
                            <tr>
                                <td>{{ $val->nama }}</td>
                                <td colspan="2">
                                    <div class="input-group" id="reqView">
                                        <input class="form-control" name="viewStart" type="text"
                                            value="{{ $tgl_awal }}" readonly>
                                        <input class="form-control" name="viewEnd" type="text"
                                            value="{{ $tgl_akhir }}" readonly>
                                    </div>
                                    <div class="input-group" id="reqEdit" style="display: none">
                                        <input type="text" class="form-control" name="tanggal[{{ $val->jadwal_kegiatan_id }}]" value="{{ $tgl }}" />
                                        <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <button type="submit" class="btn btn-primary waves-effect waves-light me-1" style="display: none"
                    id="btnSubmit">
                    Submit
                </button>
                </form>
            </div>
        </div>
    </div> <!-- end col -->
</div> <!-- end row -->
@endsection

@section('js')
<script type="text/javascript">
    $(function() {
        $('input[name^="tanggal"]').daterangepicker({
            timePicker: true,
            timePicker24Hour: true,
            locale: {
                format: 'DD-MM-YYYY HH:mm'
            }
        });
    });

    $( "#btnEdit" ).click(function() {
        $("[id^='reqEdit']").show();
        $("[id^='reqView']").hide();

        $( "#btnSimpan" ).show();
        $( "#btnEdit" ).hide();
    });

    function submitForm()
    {
        $('#btnSubmit').click();
    }
</script>
@endsection
