@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection
@php
    $jenis = $data['jenis']['0'];
    $id = $jenis->jenis_id;
@endphp

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Setting</li>
                    <li class="breadcrumb-item"><a href="{{ URL::to('operator/jenis') }}">Kategori PMW</a></li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! Form::model($jenis, ['route' => ['operator.jenis.update', $id], 'method'=>'patch', 'class'=>'form-horizontal']) !!}
                    {!! csrf_field() !!}
                        <div class="row mb-3">
                            <label for="example-text-input" class="col-sm-2 col-form-label">Kategori PMW</label>
                            <div class="col-sm-10">
                                {{ Form::text('nama', null, array('class' => 'form-control', 'placeholder' => 'Masukkan Kategori PMW')) }}
                                @if ($errors->has('nama'))
                                    <span class="help-block">{{$errors->first('nama')}}</span>
                                @endif
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="example-search-input" class="col-sm-2 col-form-label">Deskripsi</label>
                            <div class="col-sm-10">
                                {{ Form::textarea('keterangan', null, array('class' => 'form-control', 'id' => 'keterangan', 'data-info' => 'keterangan')) }}
                                @if ($errors->has('keterangan'))
                                    <span class="help-block">{{$errors->first('keterangan')}}</span>
                                @endif
                            </div>
                        </div>

                        <div class="mb-0">
                            <div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light me-1">
                                    Submit
                                </button>
                                <button type="reset" class="btn btn-secondary waves-effect">
                                    Cancel
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>

</script>
@endsection
