@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Setting</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    <a href="{{ URL::to('operator/jenis/create') }}" type="button" class="btn btn-primary waves-effect waves-light"> <i class="fas fa-plus-circle"></i> Tambah Data</a>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="example" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>id</th>
                                    <th>Kategori PMW</th>
                                    <th>Deskripsi</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>
    $(document).ready(function(){
        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('operator.getJenis')}}"
            },
            columns: [
                { data: 'jenis_id' },
                { data: 'nama' },
                { data: 'keterangan' },
                { data: 'aksi' },
            ],
            columnDefs: [
            {
                "targets": [ 0 ],
                "visible": false,
                "searchable": false
            }
        ]
        });
    });

    function confirmDelete(reqId)
    {
        Swal.fire({
            title: "Apakah Anda Yakin?",
            text: "Anda akan menghapus data ini!",
            icon: "warning",
            showCancelButton: !0,
            confirmButtonText: "Ya, Hapus data!",
            cancelButtonText: "Tidak, Kembali!",
            confirmButtonClass: "btn btn-success mt-2",
            cancelButtonClass: "btn btn-danger ms-2 mt-2",
            buttonsStyling: !1,
            allowOutsideClick: !1,
            showLoaderOnConfirm: true
            }).then((result) => {
                if (result.value){
                    $.ajax({
                        url:'{{url("/jenis/")}}/' +reqId,
                        type:'DELETE',
                        data:{
                            "_token": "{{ csrf_token() }}",
                        },
                        dataType: "JSON",
                    })
                    .done(function(response){
                        swal.fire('Deleted!', response.message, response.status).then(function(){
                            location.reload();
                        });
                    })
                    .fail(function(){
                        swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
                    });
                }
                else
                {
                    swal.fire('Batal!', 'Data batal dihapus.', 'error');
                }

            })
    }


    //     }).then(function(t) {
    //         t.value ? Swal.fire({
    //             icon: "success",
    //             title: "Sukses!",
    //             text: "Data berhasil dihapus.",
    //             type: "success"
    //         }) : t.dismiss === Swal.DismissReason.cancel && Swal.fire({
    //             icon: "error",
    //             title: "Batal!",
    //             text: "Data batal dihapus.",
    //             type: "error"
    //         })
    //     });
    // }

    // function confirmDelete(reqId) {
    //     swal({
    //             title: "Apakah Anda Yakin?",
    //             text: "Anda akan menghapus data ini!",
    //             icon: "warning",
    //             buttons: true,
    //             dangerMode: true,
    //         })
    //     .then((willDelete) => {
    //         if (willDelete) {
    //             $.ajax({
    //                 type:'DELETE',
    //                 url:'{{url("/jenis/")}}/' +reqId,
    //                 data:{
    //                     "_token": "{{ csrf_token() }}",
    //                 },
    //                 dataType: "JSON",
    //                 success: function (result) {
    //                     // console.log(result);
    //                     swal("Sukses!", "Data berhasil dihapus.", "success").then(function(){
    //                         location.reload();
    //                     });
    //                 },
    //                 error: function (xhr, ajaxOptions, thrownError) {
    //                     swal("Error!", "Data gagal dihapus.", "error").then(function(){
    //                         location.reload();
    //                     });
    //                 }
    //             });
    //             // document.location.reload();
    //         } else {
    //             swal("Data batal dihapus.", {
    //                 icon: "error",
    //             });
    //         }
    //     });
    // };
</script>
@endsection
