@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Operator</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                    {{--  --}}
                </div>
            </div>
        </div>

    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {!! Form::model($pengumuman, ['route' => ['operator.pengumuman.update', $pengumuman->id], 'method'=>'patch', 'files' => 'true', 'enctype'=>'multipart/form-data']) !!}
                        @csrf
                        <div class="row">
                            <label class="col-sm-3 col-form-label"></label>
                            <div class="col-sm-12">
                                <label for="kode" class="col-sm-2 col-form-label">Pengumuman</label>
                                    <div class="col-sm-10">
                                        <textarea id="elm1" name="pengumuman" name="area">{!! $pengumuman->pengumuman !!}</textarea>
                                        <input class="form-control" type="hidden" id="peg_id" name="peg_id" value="{{ $pengumuman->id }}" >
                                    </div>
                                <br/>
                                <label for="kode" class="col-sm-2 col-form-label">Pengumuman File</label>
                                <div class="col-sm-10">
                                    @if ($errors->has('file')) <span class="text-danger">{{ $errors->first('file') }}</span> @endif
                                    <input type="file" name="file" class="form-control" id="input-file">
                                    <iframe id="view-pdf" width="80%" height="100%" src="{{ $pengumuman ? 'https://statik.unesa.ac.id/simpmw/pengumuman/'.$pengumuman->file : '' }}" frameborder="0"></iframe>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary waves-effect waves-light me-1" id="btnSubmit"> Submit </button>
                    {{ Form::close() }}
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script src="{{ asset('theme/libs/tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('theme/js/pages/form-editor.init.js') }}"></script>
<script>
    $(function(){
        $('#input-file').change(function(){
            var input = this;
            var url = window.URL.createObjectURL(this.files[0]);
            $('#view-pdf').attr('src',url);
            $('#view-pdf').attr('height','500px');
        })
    })

    function hapus(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menghapus usulan ini?',
            text: "file yang sudah terupload juga terhapus",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('mahasiswa.proposal.hapus') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            title: 'Data Berhasil Di Hapus',
                            icon: 'success',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        $('#'+rowId).remove();
                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }
</script>
@endsection
