@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Seleksi Internal</li>
                    <li class="breadcrumb-item">Daftar Proposal Seleksi Internal</li>
                    <li class="breadcrumb-item">Penilaian Proposal Seleksi Internal</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    {{ Form::open(['url' => route('reviewer.seleksi-internal.store'), 'method' => 'post', 'id' => 'proposal', 'files' => 'true', 'enctype'=>'multipart/form-data']) }}
                    @csrf
                    <h4 class="card-title">{!! $title !!}</h4>
                    <p class="card-title-desc"></p>
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Judul</label>
                        <div class="col-sm-10">
                            <span>{{ $proposal ? $proposal->judul : '' }}</span>
                        </div>
                    </div>
                    <div class=" row mb-3">
                        <label class="col-sm-2 col-form-label">Kategori PMW</label>
                        <div class="col-sm-10">
                            <span>{{ $proposal ? $proposal->jenis_pkm : '' }}</span>
                        </div>
                    </div>
                    <div class="row mb-3" class="dropzone">
                        <label for="kode" class="col-sm-2 col-form-label">Proposal</label>
                        <div class="col-sm-10">
                            @if($proposal->upload_dokumen)
                                <iframe id="view-pdf" width="100%" height="400px" src="https://statik.unesa.ac.id/simpmw/proposal/{{ $proposal->periode }}/{{ $proposal->upload_dokumen }}" frameborder="0"></iframe>
                            @else
                                <div class="alert alert-danger alert-dismissible fade show mb-0" role="alert">
                                    <strong>Informasi!</strong> File tidak ditemukan.
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="row mb-3" class="dropzone">
                        <label for="kode" class="col-sm-2 col-form-label">Tautan</label>
                        <div class="col-sm-10">
                            <ul>
                                @foreach ($proposal->proposalUrl as $item)
                                    @if($item->url && $item->url !== '-')
                                        <li>
                                            <a class="btn btn-link" href="{{ $item->url }}">{{ $item->url_name }}</a>
                                            <p>{{ $item->deskripsi }}</p>
                                        </li>
                                    @else
                                        <li>
                                            <div class="alert alert-danger mb-0" role="alert">
                                                <strong>Informasi!</strong> File tidak ditemukan.
                                            </div>
                                        </li>
                                    @endif
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Komponen Penilaian : </label>
                        <div class="col-sm-10 table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr style="text-align: center">
                                        <th>Komponen</th>
                                        <th style="width: 10%">Nilai</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $total = 0;
                                    @endphp
                                    @foreach ($komponen as $res => $val)
                                        @php
                                            if(count($detil) == 0)
                                                $skor = '1';
                                            else
                                                $skor = $detil[$val->jenis_penilaian_monev_id]?:'1';

                                            $nilai = $skor*$val->bobot?:$val->bobot;
                                        @endphp
                                        <tr class="table-light">
                                            <td>
                                                <input type="hidden" name="jenis_penilaian_id[]" value="{{ $val->jenis_penilaian_monev_id }}">
                                                <span>{{ $val->nama }}</span>
                                            </td>
                                            <td>
                                                <select name="skor[]" class="hitung_skor" data-id="{{ $val->jenis_penilaian_monev_id }}">
                                                    <option value="1" @if($skor == '1') selected="selected" @endif>1</option>
                                                    <option value="2" @if($skor == '2') selected="selected" @endif>2</option>
                                                    <option value="3" @if($skor == '3') selected="selected" @endif>3</option>
                                                    <option value="4" @if($skor == '4') selected="selected" @endif>4</option>
                                                    <option value="5" @if($skor == '5') selected="selected" @endif>5</option>
                                                    <option value="6" @if($skor == '6') selected="selected" @endif>6</option>
                                                </select>
                                            </td>
                                        </tr>
                                        @php
                                            $total += $nilai;
                                        @endphp
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="3"><b>TOTAL NILAI</b></td>
                                        <td><span id='varTotalNilai'><b>{{ $total }}</b></span></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <label for="kode" class="col-sm-2 col-form-label">Komentar Reviewer : </label>
                        <div class="col-sm-10">
                            <textarea name="komentar" class="form-control" rows="3">{{ $reviewer_proposal->komentar?:'' }}</textarea>
                        </div>
                    </div>
                    <div class="mb-0">
                        <div>
                            <input name="reviewer_proposal_id" type="hidden" value="{{ $reviewer_proposal->reviewer_proposal_id?:'' }}">
                            <button type="submit" class="btn btn-primary waves-effect waves-light me-1"> Submit </button>
                            <button type="reset" class="btn btn-secondary waves-effect"> Cancel </button>
                        </div>
                    </div>
                {{ Form::close() }}
                <br>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')

<script>
    // sum();
    $(function(){
        $('#input-file').change(function(){
            var input = this;
            var url = window.URL.createObjectURL(this.files[0]);
            $('#view-pdf').attr('src',url);
            $('#view-pdf').attr('height','500px');
        });

        $('.hitung_skor').on('change', function() {
            var id = $(this).attr("data-id");
            var val = $(this).find(":checked").val();
            var bobot = 1;
            var nilai = val * bobot;
            $('#varNilai-'+id).text(nilai);

            sum();
        });
    });

    function sum(){
        var sum = 0;
        $('.hitung_skor').each(function () {
            sum += Number($(this).val());
        });

        $('#varTotalNilai').text(sum);
    }
</script>
@endsection
