<?php

namespace App\Http\Controllers\Dosen;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\GetDataApiController;

use App\Models\Kelompok;
use App\Models\KelompokDetail;
use App\Models\Periode;

use Session;
use Alert;

class KelompokController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $title      = 'Daftar Kelompok';
        $bio        = auth()->user()->rBiodata;
        $getDosen   = GetDataApiController::getDosen();
        // $periode    = Periode::where('status', 1)->first();
        $periode    = Periode::query()->orderBy('nama', 'ASC')->get();
        $year       = !is_null($request->year) ? $request->year : now()->year;

        $kelompok = Kelompok::with(['rAnggota'])
                    // ->where('nidn_dosen', $bio->noidentitas)
                    // ->when($bio->noidentitas !== null, function ($query) use ($bio) {
                    //     return $query->where('nidn_dosen', $bio->noidentitas)
                    //     ->orWhereRaw('LOWER(nama_dosen) = ?', [strtolower($bio->name)]);
                    // })
                    ->where(function ($query) use ($bio) {
                        $query->where('nidn_dosen', $bio->noidentitas)
                              ->orWhereRaw('LOWER(nama_dosen) = ?', [strtolower($bio->name)]);
                    })
                    ->where('kirim', '1')
                    ->whereYear('created_at', $year)
                    ->orderBy('kode')
                    ->get();

        $cekKel   = $kelompok->where('created_user', auth()->user()->id)->count();

        $data = [
            'kelompok'  => $kelompok,
            'title'     => $title,
            'cekKel'    => $cekKel,
            'dosen'     => $getDosen['data'],
            'periode'   => $periode,
            'year'      => $year,
        ];

        return view('backend.dosen.kelompok.index', $data);
    }

    public function tolak(Request $request)
    {
        $kel = $request->except('_token');

        $kelompok = Kelompok::query()->find(decrypt($kel['id']));

        $kelompok->status = 2;
        $kelompok->save();

        Alert::success('Berhasil disimpan');

        return redirect()->route('dosen.kelompok.index');
    }

    public function terima(Request $request)
    {
        $kel = $request->except('_token');

        $kelompok = Kelompok::query()->find(decrypt($kel['id']));

        $kelompok->status = 1;
        $kelompok->save();

        Alert::success('Berhasil disimpan');

        return redirect()->route('dosen.kelompok.index');
    }

    public function lihat(Request $request)
    {
        $kelompok_detil = KelompokDetail::where('kelompok_id', $request->kelompok_id)->get();

        $data = '';
        $no = 1;
        $anggota= 0;
        foreach ($kelompok_detil as $key => $value) {
            if($value->status_ketua == 1)
                $keterangan = "Ketua";
            else
            {
                $anggota++;
                $keterangan = "Anggota ".$anggota?:1;
            }
            $data .= "
                            <tr>
                                <td>".$no."</td>
                                <td>".$value->nama."</td>
                                <td>".$value->nim."</td>
                                <td>".$value->fakultas."</td>
                                <td>".$value->prodi."</td>
                                <td>".$keterangan."</td>
                            </tr>
                    ";
            $no++;
        }


        $response['html'] = $data;
        echo json_encode($response);

    }

}
