<?php

namespace App\Http\Controllers\Operator;

use DB;
use URL;

use Auth;
use Uuid;
use Alert;
use Crypt;
use App\Models\Jenis;
use App\Models\Periode;

use App\Models\Kelompok;
use Illuminate\Http\Request;
use App\Models\KelompokDetail;
use App\Http\Controllers\Controller;

class KelompokController extends Controller
{
    public function index()
    {
        $periode    = Periode::query()->get();
        return view('backend.operator.kelompok.index', compact('periode'))->withTitle('Daftar Kelompok');
    }

    /* AJAX request */
    public function getData(Request $request){
        // parameter
        $status = $request->get('status');
        $tahun= $request->get('tahun');

        if($tahun == '0')
            $tahun = date('Y');

        ## Read value
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); // Rows display per page

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column']; // Column index
        $columnName = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder = $order_arr[0]['dir']; // asc or desc
        $searchValue = strtoupper($search_arr['value']); // Search value

        // Total records
        $statementGlobal = " KELOMPOK.STATUS_HAPUS = '0' ";

        if($status != "0")
        {
            // dikurang 1 karena di view mulai dari 0 sedangkan 0 itu menunggu persetujuan
            $status = $status - 1;
            $statementGlobal .= " AND STATUS = '".$status."'";
        }

        if($tahun != "0")
        {
            $statementGlobal .= " AND TO_CHAR(KELOMPOK.CREATED_AT, 'YYYY') = '".$tahun."'";
        }

        $totalRecords = Kelompok::select('count(1) as allcount')->whereRaw($statementGlobal)->count();
        $statement = " AND B.STATUS_KETUA = '1' AND (UPPER(NAMA_DOSEN) LIKE '%".$searchValue."%' OR (UPPER(NAMA) LIKE '%".$searchValue."%') OR (UPPER(NIM) LIKE '%".$searchValue."%')) ";

        $totalRecordswithFilter =   Kelompok::select('count(1) as allcount')
                                    ->join('kelompok_detil as b', 'kelompok.kelompok_id', '=', 'b.kelompok_id')
                                    ->whereRaw($statementGlobal.$statement)->count();

        // Fetch records
        $records = Kelompok::orderBy($columnName,$columnSortOrder)
            ->join('kelompok_detil as b', 'kelompok.kelompok_id', '=', 'b.kelompok_id')
            ->whereRaw($statementGlobal.$statement)
            ->selectRaw('kelompok.kelompok_id, kode, nama_dosen, nidn_dosen, status, ambil_ketua_kelompok(kelompok.kelompok_id) ketua')
            ->skip($start)
            ->take($rowperpage)
            ->get();

        $data_arr = array();

        foreach($records as $record){
            $kelompok_id = $record->kelompok_id;
            $kode = $record->kode;
            $ketua = $record->ketua;
            $ketua = explode('###', $record->ketua);
            $nama_ketua = $ketua[0];
            $nim_ketua = $ketua[1];

            $nama_dosen = $record->nama_dosen;
            $nidn_dosen = $record->nidn_dosen;
            $status = $record->status;

            if($status == '1')
            {
                $keterangan = '<span class="badge bg-success">Disetujui</span>';
                $aksi = '<a class="btn btn-warning btn-sm waves-effect waves-light aksi" role="button" data-ket="Kelompok yang sudah disetujui dan dibatalkan statusnya, dapat mengubah anggota kelompok serta harus melakukan verifikasi mandiri kembali." data-id="'.Crypt::encrypt($kelompok_id.'#0').'"><i class="fas fa-undo"></i></a>';
            }
            elseif($status == '2')
            {
                $keterangan = '<span class="badge bg-danger">Ditolak</span>';
                $aksi = '<a class="btn btn-warning btn-sm waves-effect waves-light aksi" role="button" data-ket="Kelompok yang dibatalkan status tolak akan menunggu di verifikasi kembali oleh dosen pembimbing." data-id="'.Crypt::encrypt($kelompok_id.'#0').'"><i class="fas fa-undo"></i></a>';
            }
            else
            {
                $keterangan = '<span class="badge bg-warning">Menunngu Persetujuan</span>';
                $aksi = '<a class="btn btn-success btn-sm waves-effect waves-light aksi" role="button" data-ket="Kelompok yang disetujui akan diteruskan untuk upload proposal" data-id="'.Crypt::encrypt($kelompok_id.'#1').'"><i class="fas fa-check"></i></a> <a class="btn btn-danger btn-sm waves-effect waves-light aksi" role="button" data-ket="Kelompok yang tidak di setujui tidak bisa untuk upload proposal" data-id="'.Crypt::encrypt($kelompok_id.'#2').'"><i class="fas fa-times"></i></a>';
            }

            $aksi .= ' <a class="btn btn-primary btn-sm waves-effect waves-light viewdetails" role="button" data-id="'.Crypt::encrypt($kelompok_id).'"><i class="fas fa-eye"></i></a>';

            $data_arr[] = array(
                "kelompok_id" => $kelompok_id,
                "kode" => $kode,
                "nama_ketua" => $nama_ketua,
                "nim_ketua" => $nim_ketua,
                "nama_dosen" => $nama_dosen,
                "nidn_dosen" => $nidn_dosen,
                "keterangan" => $keterangan,
                "aksi" => $aksi
            );
        }

        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }

    public function getDetil(Request $request)
    {
        $reqKelompokId = Crypt::decrypt($request->kelompok_id);
        $kelompok_detil = KelompokDetail::where('kelompok_id', $reqKelompokId)
                        ->orderBy('status_ketua', 'ASC')
                        ->orderBy('status_ketua', 'DESC')
                        ->get();

        $data = '';
        $no = 1;
        $anggota= 0;
        foreach ($kelompok_detil as $key => $value) {
            if($value->status_ketua == 1)
                $keterangan = "Ketua";
            else
            {
                $anggota++;
                $keterangan = "Anggota ".$anggota?:1;
            }

            $select = "<div class='d-flex align-items-center'>
                        <select name='keterangan[]' class=''>
                            <option value='1' ".($value->status_ketua == '1' ? 'selected' : '').">Ketua</option>
                            <option value='2' ".($value->status_ketua == '2' ? 'selected' : '').">Anggota</option>
                        </select>
                        <input type='hidden' name='kelompok_detil_id[]' value='".$value->kelompok_detil_id."'>";

                    if ($value->status_ketua != '1') {
                        $select .= "<span style='margin-left: 10px;'>".$anggota."</span>";
                    }

                    $select .= "</div>";

            $data .= "
                        <tr>
                            <td>".$no."</td>
                            <td>".$value->nama."</td>
                            <td>".$value->nim."</td>
                            <td>".$value->fakultas."</td>
                            <td>".$value->prodi."</td>
                            <td>".$select."</td>
                        </tr>
                    ";
            $no++;
        }
        $response['html'] = $data;
        echo json_encode($response);
    }

    public function create()
    {

    }

    public function store(Request $request)
    {

    }

    public function edit($id)
    {

    }

    public function update(Request $request, $id)
    {
        
    }

    public function updateKetua(Request $request)
    {
        DB::beginTransaction();
        try {
            foreach($request->kelompok_detil_id as $key => $kelompok_detil_id) {
                $status_ketua = $request->keterangan[$key];
    
                KelompokDetail::where('kelompok_detil_id', $kelompok_detil_id)
                    ->update(['status_ketua' => $status_ketua]);
            }
    
            DB::commit();
            return response()->json(['success' => true, 'message' => 'Data berhasil disimpan.']);
        } catch (\Exception $e) {
            DB::rollback();
            return response()->json(['error' => true, 'message' => 'Data gagal disimpan.']);
        }
    }

    public function destroy($id)
    {

    }

    public function prosesKelompok(Request $request)
    {
        $kel = $request->except('_token');

        $arrKel = explode('#', decrypt($kel['kelompokId']));
        $reqKelompokId = $arrKel['0'];
        $reqStatus = $arrKel['1'];

        $kelompok = Kelompok::query()->find($reqKelompokId);

        $kelompok->status = $reqStatus;
        $kelompok->save();

        return response()->json([
            'status' => 'success',
            'message' => 'Data Berhasil diubah.',
        ]);
    }
}
