<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DaftarProposalBelmawa extends Model
{
    protected $table = 'daftar_proposal_belmawa';
    protected $primaryKey = 'seleksi_belmawa_id';
    public $incrementing = false;

    protected $fillable = [
        'seleksi_belmawa_id', 'kelompok_id', 'kode_kelompok', 'jenis_pkm', 'judul_proposal', 'nama_dosen', 'identitas_dospem', 'upload_dokumen', 'status', 'status_desc', 'periode', 'status_hapus'
    ];

    public function rKelompokDetil()
    {
        return $this->hasMany(\App\Models\KelompokDetail::class, 'kelompok_id', 'kelompok_id');
    }
}
