<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\UuidTrait;

use Illuminate\Database\Eloquent\Model;
use App\Models\KelompokDetail;
use App\Models\Auth\Biodata;

class Kelompok extends Model
{
    use HasFactory;
    use UuidTrait;

    protected $table = 'kelompok';
    protected $primaryKey = 'kelompok_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'kelompok_id',
        'periode_id',
        'kode',
        'id_sdm',
        'nama_dosen',
        'nidn_dosen',
        'status',
        'status_hapus',
        'created_user',
        'created_at',
        'updated_user',
        'updated_at',
    ];

    public function rAnggota()
    {
        return $this->hasMany(KelompokDetail::class, 'kelompok_id', 'kelompok_id')->orderBy('status_ketua');
    }

    public function rBiodata()
    {
        return $this->hasOne(Biodata::class, 'id', 'created_user');
    }

}

