<?php

namespace App\Repositories\Auth;

use App\Models\Role;

class RoleRepository
{
    private $model;

    public function __construct(Role $model)
    {
        $this->model = $model;
    }

    public function roles($roles)
    {
        return $this->model
        ->when($roles, function ($query) use ($roles) {
            return $query->where('name', $roles);
        })
        ->first();
    }

    public function store($user, $role)
    {
        return $user->assignRole($role);
    }

    public function delete($user, $role)
    {
        return $user->removeRole($role);
    }


}
