@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Biodata</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->

    {{-- <div class="row">
        <div class="col-xl-4 col-md-6">
            <div class="card directory-card">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0">
                            @if (Auth::user()->roles->first()->name != 'mahasiswa')
                                <img src="https://siakadu.unesa.ac.id/photo/fotomhs/{{ $biodata->noidentitas }}.jpg" alt="" class="img-fluid img-thumbnail rounded-circle avatar-lg">
                            @else
                                <img src="https://siakadu.unesa.ac.id/photo/{{ $biodata->noidentitas }}.jpg" alt="" class="img-fluid img-thumbnail rounded-circle avatar-lg">
                            @endif
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h5 class="text-primary font-size-18 mb-1">{{ $biodata->name }}</h5>
                            <p class="font-size-12 mb-2">{{ $biodata->noidentitas }}</p>
                            <p class="mb-0">{{ $biodata->email }}</p>
                        </div>
                      </div>
                      <hr>
                    <p class="mb-0"><b>Fakultas : </b> {{ $biodata->fakultas }}</p>
                    <p class="mb-0"><b>Program Studi : </b> {{ $biodata->prodi }} </p>
                </div>
            </div>
        </div>
    </div> --}}

    <div class="row">
        <div class="col-12">
        <div class="card mb-4">
            <div class="user-profile-header-banner">
                <img src="https://t3.ftcdn.net/jpg/05/57/66/36/360_F_557663678_XvLRb0h4sDvPU8RF8Jtt9NjsOyKK5lbF.jpg" width="100%" height="250px" object-fit="cover" style="transform: scaleY(-1); z-index: 0" alt="Banner image" class="rounded-top">
            </div>
            <div class="user-profile-header d-flex flex-column flex-lg-row text-sm-start text-center" style="margin-top: -7.5rem; z-index: 1;">
            <div class="flex-shrink-0mt-n2 mx-lg-0 mx-auto mb-2">
                @if (is_null($biodata->noidentitas))
                    <img src="{{ asset('theme/images/users/user-null.jpg') }}" width="100" alt="user image" class="d-block h-auto ms-0 ms-sm-3 rounded user-profile-img" style="border: 5px solid; border-color: white;">
                @else
                    @if (Auth::user()->roles->first()->name != 'mahasiswa')
                        <img src="https://siakadu.unesa.ac.id/photo/fotomhs/{{ $biodata->noidentitas }}.jpg" alt="user image" width="80" class="d-block h-auto ms-0 ms-sm-3 rounded user-profile-img" style="border: 5px solid; border-color: white;">
                    @else
                        <img src="https://siakadu.unesa.ac.id/photo/{{ $biodata->noidentitas }}.jpg" width="80" alt="user image" class="d-block h-auto ms-0 ms-sm-3 rounded user-profile-img" style="border: 5px solid; border-color: white;">
                    @endif
                @endif
            </div>
            <div class="flex-grow-1 mt-3" style="margin-top: 3rem !important;">
                <div class="d-flex align-items-md-end align-items-sm-start align-items-center justify-content-md-between justify-content-start mx-3 flex-md-row flex-column gap-4">
                <div class="user-profile-info">
                    <h2>{{ $biodata->name }}</h2>
                    <ul class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-2">
                    <li class="list-inline-item">
                        <i class="mdi mdi-card-account-details me-1 mdi-20px"></i><span class="fw-medium">{{ $biodata->noidentitas }}</span>
                    </li>
                    <li class="list-inline-item">
                        <i class="mdi mdi-town-hall me-1 mdi-20px"></i><span class="fw-medium">{{ $biodata->prodi }} - {{ $biodata->fakultas }}</span></li>
                    </ul>
                </div>
                </div>
            </div>
            </div>
        </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            <!-- About User -->
            <div class="card mb-4">
                <div class="card-body">
                    <div style="overflow-x:auto;">
                    <style>
                        th, td {
                            padding-bottom: 10px;
                        }
                        td {
                            padding-left: 20px;
                        }
                    </style>
                    <table style="width:100%">
                        <tr>
                            <th class="card-text text-uppercase" width="20%">Biodata</th>
                            <th width="80%"> </th>
                        </tr>
                        <tr>
                            <td class="d-flex align-items-center mdi mdi-account-outline mdi-20px">
                                <span class="fw-medium mx-2 me-auto">Nama Lengkap</span>
                                <span class="text-end">:</span>
                            </td>
                            <td>{{ $biodata->name }}</td>
                        </tr>
                        <tr>
                            <td class="d-flex align-items-center mdi mdi-card-account-details-outline mdi-20px">
                                <span class="fw-medium mx-2 me-auto">NIP / NIDN</span>
                                <span class="text-end">:</span>
                            </td>
                            <td>{{ $biodata->noidentitas }}</td>
                        </tr>
                        <tr>
                            <td class="d-flex align-items-center mdi mdi-town-hall mdi-20px">
                                <span class="fw-medium mx-2 me-auto">Fakultas</span>
                                <span class="text-end">:</span>
                            </td>
                            <td>{{ $biodata->fakultas }}</td>
                        </tr>
                        <tr>
                            <td class="d-flex align-items-center mdi mdi-school-outline mdi-20px">
                                <span class="fw-medium mx-2 me-auto">Program Studi</span>
                                <span class="text-end">:</span>
                            </td>
                            <td>{{ $biodata->prodi }}</td>
                        </tr>
                        <tr>
                            <td class="d-flex align-items-center mdi mdi-gmail mdi-20px">
                                <span class="fw-medium mx-2 me-auto">Email UNESA</span>
                                <span class="text-end">:</span>
                            </td>
                            <td>{{ $biodata->email }}</td>
                        </tr>
                        <tr>
                            <td class="d-flex align-items-center mdi mdi-whatsapp mdi-20px">
                                <span class="fw-medium mx-2 me-auto">No. Telp (WA)</span>
                                <span class="text-end">:</span>
                            </td>
                            <td>
                                @if (is_null($biodata->telephone) && is_null($biodata->phone))
                                    -
                                @elseif (is_null($biodata->telephone))
                                    {{ $biodata->phone }}
                                    @elseif (is_null($biodata->phone))
                                        {{ $biodata->telephone }}
                                    @else
                                        {{ $biodata->telephone }} / {{ $biodata->phone }}
                                @endif
                            </td>
                        </tr>
                            {{-- <td class="d-flex align-items-center mb-3 mdi mdi-map-marker-radius-outline mdi-20px">
                                <span class="fw-medium mx-2 me-auto">Alamat</span>
                                <span class="text-end">:</span>
                            </td> --}}
                            {{-- <td>{{ $biodata->alamat }}</td> --}}
                        </tr>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
<script>
    function hapus(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menghapus Kelompok?',
            text: "Semua anggota kelompok juga akan terhapus",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('mahasiswa.kelompok.hapus') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            title: 'Data Berhasil Di Hapus',
                            icon: 'success',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        $('#'+rowId).remove();
                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }
</script>
@endsection
