@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">
                        <a href="{{ URL::to('mahasiswa/proposal/create') }}" type="button" class="btn btn-primary waves-effect waves-light"> <i class="fas fa-plus-circle"></i> Tambah Data</a>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr>
                                <th>No</th>
                                <th>Kode Kelompok</th>
                                <th>Identitas Ketua</th>
                                <th>Identitas Dosen Pembimbing</th>
                                <th>Kategori PMW</th>
                                <th>Judul Proposal</th>
                                <th>Catatan Harian (Logbook)</th>
                                <th>Laporan Kemajuan</th>
                                <th>Aksi</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach ($proposal as $item)
                                @php $token = Str::random(30); @endphp
                                <tr id="row-{{ $token }}">
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $item->rKelompok->kode }}</td>
                                    <td>{{ $item->rKelompok->rBiodata->name }} <br> {{ $item->rKelompok->rBiodata->noidentitas }} <br> {{ $item->rKelompok->rBiodata->fakultas }} <br> {{ $item->rKelompok->rBiodata->prodi }}</td>
                                    <td>{{ $item->rKelompok->nama_dosen }} <br> {{ $item->rKelompok->nidn_dosen }}</td>
                                    <td>{{ $item->rJenis->nama }}</td>
                                    <td>{{ $item->judul }}</td>
                                    <td> <a data-bs-toggle="modal" data-bs-target="#uploadRev" type="button" class="btn btn-warning btn-sm waves-effect waves-light"> <i class="fas fa-file-upload"></i> Upload</a> </td>
                                    <td> <a data-bs-toggle="modal" data-bs-target="#uploadRev" type="button" class="btn btn-warning btn-sm waves-effect waves-light"> <i class="fas fa-file-upload"></i> Upload</a> </td>
                                    <td>
                                        <button data-bs-toggle="modal" data-bs-target="{{ '#lihat'.$item->proposal_id }}" href="{{ URL::to('mahasiswa/kelompok-new', encrypt($item->proposal_id)) }}" class="btn btn-info btn-sm">Lihat</button>
    
                                        <div id="{{ 'lihat'.$item->proposal_id }}" class="modal fade" tabindex="-1" role="dialog"
                                            aria-labelledby="lihatLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-xl">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="lihatLabel">Detail Proposal </h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <p>
                                                            <div class="table-responsive">
                                                                <table class="table mb-0">
                                                                    <tr>
                                                                        <th>Judul Proposal</th>
                                                                        <td>{{ $item->judul }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Kategori PMW</th>
                                                                        <td>{{ $item->rJenis->nama }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Status</th>
                                                                        <td>
                                                                            @if(is_null($item->status))
                                                                                <span class="badge bg-danger">Lolos Seleksi Internal</span>
                                                                            @else
                                                                                <span class="badge bg-success">Tidak Lolos Seleksi Internal</span>
                                                                            @endif
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Proposal</th>
                                                                        <td> <iframe id="view-pdf" width="100%" height="200px" src="https://statik.unesa.ac.id/simpmw/proposal/{{ $item->rPeriode->nama }}/{{ $item->upload_dokumen }}" frameborder="0"></iframe></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <th>Komentar</th>
                                                                        <td> </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
    
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->
@endsection

@section('js')
<script>

    function hapus(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menghapus Kelompok?',
            text: "Semua anggota kelompok juga akan terhapus",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('mahasiswa.proposal.hapus') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            title: 'Data Berhasil Di Hapus',
                            icon: 'success',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        $('#'+rowId).remove();
                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }
</script>
@endsection
