@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Status : </label>
                                <div class="col-sm-6">
                                    <select class="form-select" name="reqStatus" id="reqStatus">
                                        <option value="0">Semua</option>
                                        <option value="1">Menunggu Persetujuan</option>
                                        <option value="2">Disetujui</option>
                                        <option value="3">Ditolak</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-3 col-form-label">Tahun : </label>
                                <div class="col-sm-6">
                                    <select class="form-select" name="reqTahun" id="reqTahun">
                                        <option value="0">Semua</option>
                                        @foreach ($periode as $res)
                                            <option value="{{ $res->nama }}" @php if($res->nama == date('Y')) echo 'selected'; @endphp>{{ $res->nama }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    {!! csrf_field() !!}
                    <div class="table-responsive">
                        <table id="example" class="table table-bordered dt-responsive wrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Kode Kelompok</th>
                                    <th>Ketua</th>
                                    <th>NIM</th>
                                    <th>Dosen Pembimbing</th>
                                    <th>NIDN</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

    <div class="modal fade" id="empModal">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Data Kelompok</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive">
                        <form id="form-update-ketua" method="POST" action="{{ route('operator.update-kelompok') }}">
                            @csrf
                            {{-- @method('PUT') --}}
                        <table class="w-100" id="tblempinfo">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama</th>
                                    <th>NIM</th>
                                    <th>Fakultas</th>
                                    <th>Program Studi</th>
                                    <th>Keterangan</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" form="form-update-ketua">Submit</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>
    $("#reqStatus, #reqTahun").select2({
        placeholder: "Semua",
        allowClear: true
    });

    $(document).ready(function(){
        // DataTable
        var oTable = $('#example').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                "url" : "{{route('operator.getKelompok')}}",
                "data" : function ( data )
                {
                    data.status = $("#reqStatus").val();
                    data.tahun = $("#reqTahun").val();
                }
            },
            columns: [
                { data: 'kelompok_id' },
                { data: 'kode' },
                { data: 'nama_ketua' },
                { data: 'nim_ketua' },
                { data: 'nama_dosen' },
                { data: 'nidn_dosen' },
                { data: 'keterangan' },
                { data: 'aksi' },
            ],
            columnDefs: [
            {
                "targets": [ 0 ],
                "visible": false,
                "searchable": false
            }
        ]
        });

        $('#reqStatus, #reqTahun').change(function(){
            oTable.draw();
        });

        $('#example').on('click','.viewdetails',function(){
            var kelId = $(this).attr('data-id');


        if(kelId != null || kelId != ''){
                // Empty modal data
                $('#tblempinfo tbody').empty();

                $.ajax({
                    url: "{{route('operator.getDetilKelompok')}}",
                    data : {
                        "kelompok_id": kelId,
                    },
                    dataType: 'json',
                    success: function(response){
                        // Add user details
                        $('#tblempinfo tbody').html(response.html);

                        // Display Modal
                        $('#empModal').modal('show');
                    }
                });
        }
        });

        // $('#example').on('click','.aksi',function(){
        //     var kelId = $(this).attr('data-id');
        //     var ket = $(this).attr('data-ket');

        //     if(kelId != null || kelId != ''){
        //         Swal.fire({
        //             title: "Apakah Anda Yakin?",
        //             text: ket,
        //             icon: "warning",
        //             showCancelButton: !0,
        //             confirmButtonText: "Ya!",
        //             cancelButtonText: "Tidak, Kembali!",
        //             confirmButtonClass: "btn btn-success mt-2",
        //             cancelButtonClass: "btn btn-danger ms-2 mt-2",
        //             buttonsStyling: !1,
        //             allowOutsideClick: !1,
        //             showLoaderOnConfirm: true
        //         }).then((result) => {
        //             if (result.value){
        //                 $.ajax({
        //                     url:'{{url("/operator/proses-kelompok")}}',
        //                     type:'POST',
        //                     data:{
        //                         "_token": "{{ csrf_token() }}",
        //                         "kelompokId": kelId
        //                     },
        //                     dataType: "JSON",
        //                 })
        //                 .done(function(response){
        //                     swal.fire(response.status, response.message, response.status).then(function(){
        //                         oTable.ajax.reload();
        //                     });
        //                 })
        //                 .fail(function(){
        //                     swal.fire('Oops...', 'Something went wrong with ajax !', 'error');
        //                 });
        //             }
        //             else
        //             {
        //                 swal.fire('Batal!', 'Data batal diproses.', 'error');
        //             }
        //         })
        //     }
        // });

        $('#example').on('click','.aksi',function(){
            var kelId = $(this).attr('data-id');
            var ket = $(this).attr('data-ket');

            if(kelId != null || kelId != ''){
                Swal.fire({
                    title: "Apakah Anda Yakin?",
                    text: ket,
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Ya!",
                    cancelButtonText: "Tidak, Kembali!",
                    confirmButtonColor: "#d33",       // Merah
                    cancelButtonColor: "#3085d6",     // Biru
                    showLoaderOnConfirm: true,
                    allowOutsideClick: false,
                    preConfirm: () => {
                        return $.ajax({
                            url: '{{ url("/operator/proses-kelompok") }}',
                            type: 'POST',
                            data: {
                                "_token": "{{ csrf_token() }}",
                                "kelompokId": kelId
                            },
                            dataType: "json"
                        }).then(response => {
                            return response;
                        }).catch(error => {
                            Swal.showValidationMessage(
                                `Request gagal: ${error.statusText}`
                            );
                        });
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: 'Berhasil!',
                            text: result.value.message,
                            icon: result.value.status,
                            confirmButtonText: 'OK'
                        }).then(() => {
                            oTable.ajax.reload();
                        });
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire('Dibatalkan', 'Tidak jadi memproses data.', 'info');
                    }
                });
            }
        });

        $('#form-update-ketua').on('submit', function(e) {
            e.preventDefault();

            var form = $(this);
            var url = form.attr('action');

            $.ajax({
                type: "POST",
                url: url,
                data: form.serialize(), // serializes the form's elements
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        swal({
                            title: "Berhasil!",
                            text: response.message,
                            icon: "success",
                            button: "OK",
                        }).then(function() {
                            // Reload or redirect after success if needed
                            location.reload();
                        });
                    } else {
                        swal({
                            title: "Gagal!",
                            text: response.message,
                            icon: "error",
                            button: "OK",
                        });
                    }
                },
                error: function(xhr, status, error) {
                    swal({
                        title: "Gagal!",
                        text: "Terjadi kesalahan pada server.",
                        icon: "error",
                        button: "OK",
                    });
                }
            });
        });
    });
</script>
@endsection
