<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\DashboardController;

use App\Http\Controllers\Operator\UserController;
use App\Http\Controllers\Operator\CheckController;
use App\Http\Controllers\Operator\JenisController;
use App\Http\Controllers\Operator\SelectController;
use App\Http\Controllers\Mahasiswa\AnggotaController;
use App\Http\Controllers\Operator\KelompokController;
use App\Http\Controllers\Operator\ProposalController;
use App\Http\Controllers\Operator\ReviewerController;
use App\Http\Controllers\Authentication\LoginController;
use App\Http\Controllers\Reviewer\DaftarMonevController;
use App\Http\Controllers\Operator\UserExternalController;
use App\Http\Controllers\Operator\MonevProposalController;
use App\Http\Controllers\Operator\ReviewerMonevController;
use App\Http\Controllers\Operator\PengumumanController;

use App\Http\Controllers\Reviewer\DaftarSeleksiController;
use App\Http\Controllers\Operator\DaftarProposalController;
use App\Http\Controllers\Operator\JadwalKegiatanController;
use App\Http\Controllers\Dosen\MonevController as DosenMonev;
use App\Http\Controllers\Operator\JenisPenilaianMonevController;
use App\Http\Controllers\Dosen\BiodataController as DosenBiodata;

use App\Http\Controllers\Dosen\SeleksiController as DosenSeleksi;
use App\Http\Controllers\Dosen\KelompokController as DosenKelompok;
use App\Http\Controllers\Dosen\ProposalController as DosenProposal;
use App\Http\Controllers\Mahasiswa\MonevController as MonevMahasiswa;
use App\Http\Controllers\Mahasiswa\LuaranController as LuaranMahasiswa;
use App\Http\Controllers\Mahasiswa\BiodataController as BiodataMahasiswa;
use App\Http\Controllers\Mahasiswa\SeleksiController as SeleksiMahasiswa;
use App\Http\Controllers\Mahasiswa\KelompokController as MahasiswaKelompok;
use App\Http\Controllers\Mahasiswa\MonevController;
use App\Http\Controllers\Mahasiswa\ProposalController as MahasiswaProposal;
use App\Models\BuktiAnggaran;
use App\Models\DaftarProposal;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('mahasiswa.index');
// });

Route::get('/', function () {
    return view('auth.login');
});

Route::group(['namespace' => 'Authentication'], function () {
    Route::get('sso/{email}/{sessionid}', [LoginController::class, 'sso']);
});

Route::get('login', [App\Http\Controllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
Route::post('login', [Laravel\Fortify\Http\Controllers\AuthenticatedSessionController::class, 'store']);

Route::group(['middleware' => ['auth:sanctum', 'verified']], function () {

    Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard.index');
    Route::get('getChartData', [DashboardController::class, 'getChartData'])->name('dashboard.chart-data');

    Route::post('selectmahasiswa', [SelectController::class, 'mahasiswa'])->name('mahasiswa-select');

    Route::name('mahasiswa.')->prefix('mahasiswa')->middleware(['role:operator|mahasiswa|tendik'])->group(function () {

        //biodata
        Route::resource('biodata', BiodataMahasiswa::class);

        //kelompok
        Route::resource('kelompok', MahasiswaKelompok::class);
        Route::get('/kelompok-new/{id}', [MahasiswaKelompok::class, 'newkelompok'])->name('kelompok.createnew');
        Route::post('/kelompok-kirim', [MahasiswaKelompok::class, 'kirim'])->name('kelompok.kirim');
        Route::post('/kelompok-hapus', [MahasiswaKelompok::class, 'hapus'])->name('kelompok.hapus');

        Route::resource('anggota', AnggotaController::class);

        //proposal
        Route::resource('proposal', MahasiswaProposal::class);
        Route::post('/proposal-hapus', [MahasiswaProposal::class, 'hapus'])->name('proposal.hapus');

        //seleksi
        Route::resource('seleksi', SeleksiMahasiswa::class);
        Route::get('/seleksi-internal', [SeleksiMahasiswa::class, 'seleksiInternal'])->name('seleksi-internal');
        Route::get('/seleksi-belmawa', [SeleksiMahasiswa::class, 'seleksiBelmawa'])->name('seleksi-belmawa');
        Route::get('/seleksi-internal-revisi', [SeleksiMahasiswa::class, 'internalRevisi'])->name('seleksi-internal-revisi');
        Route::get('/seleksi-internal-lihat', [SeleksiMahasiswa::class, 'lihatInternal'])->name('seleksi-internal.lihat');

        Route::get('/seleksi-belmawa/revisi/{id}', [SeleksiMahasiswa::class, 'editBelmawa'])->name('seleksi-belmawa-revisi');
        Route::post('/seleksi-belmawa/upload', [SeleksiMahasiswa::class, 'uploadBelmawa'])->name('seleksi-belmawa-upload');
        Route::post('/seleksi-belmawa', [SeleksiMahasiswa::class, 'hapus'])->name('seleksi-belmawa.hapus');

        //monev
        Route::get('/monev/{id}', [MonevMahasiswa::class, 'monev'])->name('monev-index');

        Route::get('/monev-satu', [MonevMahasiswa::class, 'monevsatu'])->name('monev-satu');
        Route::get('/monev-dua', [MonevMahasiswa::class, 'monevdua'])->name('monev-dua');
        Route::get('/monev-tiga', [MonevMahasiswa::class, 'monevtiga'])->name('monev-tiga');

        Route::get('/monev-revisi/{id}', [MonevMahasiswa::class, 'revisiMonev'])->name('monev-revisi');
        Route::post('/monev-revisi/upload', [MonevMahasiswa::class, 'uploadMonev'])->name('monev-revisi-upload');
        // Route::get('/monev-revisi-all/{id}', [MonevMahasiswa::class, 'revisiMonevAll'])->name('monev-revisi-all');
        // Route::post('/monev-revisi-all/upload', [MonevMahasiswa::class, 'uploadMonevRevisi'])->name('monev-revisi-all-upload');

        //monev-ii -> anggaran
        Route::get('/monev/II/anggaran/{id}', [MonevMahasiswa::class, 'buktiAnggaran'])->name('monev-anggaran');
        Route::post('/monev/II/anggaran/store', [MonevMahasiswa::class, 'storeAnggaran'])->name('monev-anggaran-store');

        //luaran
        Route::resource('luaran', LuaranMahasiswa::class);
        Route::post('/luaran-hapus', [LuaranMahasiswa::class, 'hapus'])->name('luaran.hapus');
        Route::post('/anggaran/delete', [MonevController::class, 'hapusAnggaran'])->name('anggaran.hapus');
    });

    Route::name('dosen.')->prefix('dosen')->middleware(['role:operator|dosen|tendik'])->group(function () {

        //biodata
        Route::resource('biodata', DosenBiodata::class);

        //kelompok
        Route::resource('kelompok', DosenKelompok::class);
        Route::get('/kelompok-new/{id}', [DosenKelompok::class, 'newkelompok'])->name('kelompok.createnew');
        Route::post('/kelompok-tolak', [DosenKelompok::class, 'tolak'])->name('kelompok.tolak');
        Route::post('/kelompok-terima', [DosenKelompok::class, 'terima'])->name('kelompok.terima');
        Route::get('/kelompok-lihat', [DosenKelompok::class, 'lihat'])->name('kelompok.lihat');

        //proposal
        Route::resource('proposal', DosenProposal::class);
        Route::post('/proposal-setuju', [DosenProposal::class, 'setuju'])->name('proposal.setuju');
        Route::get('/proposal-lihat', [DosenProposal::class, 'lihat'])->name('proposal-lihat');
        Route::get('/proposal-approv/{id}', [DosenProposal::class, 'approve'])->name('proposal.approv');
        Route::post('/proposal-tolak', [DosenProposal::class, 'tolak'])->name('proposal.tolak');

        //seleksi
        Route::resource('seleksi', DosenSeleksi::class);
        Route::get('/seleksi-internal', [DosenSeleksi::class, 'seleksiInternal'])->name('seleksi-internal');
        Route::get('/seleksi-belmawa', [DosenSeleksi::class, 'seleksiBelmawa'])->name('seleksi-belmawa');
        Route::get('/seleksi-internal-revisi', [DosenSeleksi::class, 'internalRevisi'])->name('seleksi-internal-revisi');
        Route::get('/seleksi-internal-lihat', [DosenSeleksi::class, 'lihatInternal'])->name('seleksi-internal.lihat');

         //monev
        Route::get('/monev/{id}', [DosenMonev::class, 'monev'])->name('monev-index');

         //luaran
        Route::get('/luaran-dosen/{id}', [luaranMahasiswa::class, 'dosen'])->name('luaran-dosen');
    });

    Route::name('operator.')->prefix('operator')->middleware(['role:operator'])->group(function () {

        Route::resource('kelompok', KelompokController::class);
        Route::get('getKelompok', [KelompokController::class, 'getData'])->name('getKelompok');
        Route::get('getDetilKelompok', [KelompokController::class, 'getDetil'])->name('getDetilKelompok');
        Route::post('proses-kelompok', [KelompokController::class, 'prosesKelompok'])->name('proses-kelompok');
        Route::post('kelompok/update-kelompok', [KelompokController::class, 'updateKetua'])->name('update-kelompok');

        Route::resource('proposal', ProposalController::class);
        Route::get('getProposal', [ProposalController::class, 'getData'])->name('getProposal');
        Route::get('getDetilProposal', [ProposalController::class, 'getDetil'])->name('getDetilProposal');
        Route::get('cetak-proposal', [ProposalController::class, 'cetak_proposal'])->name('cetak-proposal');
        Route::post('proses-proposal', [ProposalController::class, 'prosesProposal'])->name('proses-proposal');

        Route::resource('jenis', JenisController::class);
        Route::get('getJenis', [JenisController::class, 'getData'])->name('getJenis');
        Route::resource('jenis-penilaian-monev', JenisPenilaianMonevController::class);
        Route::get('getJenisPenilaianMonev', [JenisPenilaianMonevController::class, 'getData'])->name('getJenisPenilaianMonev');

        Route::get('rowJenisPenilaianMonev', function () {
            return view('backend/operator/jenis_penilaian_monev/row');
        });

        Route::resource('jadwal-kegiatan', JadwalKegiatanController::class);
        Route::resource('seleksi-internal-reviewer', ReviewerController::class);
        Route::get('getReviewer', [ReviewerController::class, 'getData'])->name('getReviewer');
        Route::get('getDosen', [ReviewerController::class, 'getDosen'])->name('getDosen');

        // SELEKSI INTERNAL
        Route::resource('seleksi_internal_reviewer', ReviewerController::class);
        Route::resource('seleksi-internal-proposal', DaftarProposalController::class);
        Route::post('seleksi-internal-proposal-jenis', [DaftarProposalController::class, 'change_jenis'])->name('seleksi-internal-proposal-jenis');
        Route::post('seleksi-internal-reviewer-approval', [DaftarProposalController::class, 'approval'])->name('seleksi-internal.approval');
        Route::get('getDaftarProposal', [DaftarProposalController::class, 'getData'])->name('getDaftarProposal');
        Route::get('cetak-daftar-proposal-new', [DaftarProposalController::class, 'cetak_daftar_proposal'])->name('cetak-daftar-proposal');
        // Route::get('cetak-daftar-proposal-new', [DaftarProposalController::class, 'cetak_daftar_proposal_new'])->name('cetak-daftar-proposal-new');
        Route::post('seleksi-internal/buka-penilaian', [DaftarProposalController::class, 'bukaPenilaian'])->name('seleksi-internal.buka-penilaian');

        // SELEKSI BELMAWA
        Route::get('seleksi-belmawa', [DaftarProposalController::class, 'index_belmawa'])->name('seleksi-belmawa');
        Route::get('/seleksi-belmawa-approval/{id}/{status}', [DaftarProposalController::class, 'approval_belmawa'])->name('seleksi-belmawa.approval_belmawa');
        Route::get('getDaftarProposalBelmawa', [DaftarProposalController::class, 'getDataBelmawa'])->name('getDaftarProposalBelmawa');
        Route::get('cetak-daftar-belmawa', [DaftarProposalController::class, 'cetak_daftar_belmawa'])->name('cetak-daftar-belmawa');

        // Route::resource('monev-internal-reviewer', ReviewerMonevController::class);
        Route::get('getReviewerMonev', [ReviewerMonevController::class, 'getDataMonev'])->name('getReviewerMonev');

        Route::get('monev-internal-reviewer/{id}', [ReviewerMonevController::class, 'index'])->name('monev-internal-reviewer');
        Route::resource('monev-internal-reviewer', ReviewerMonevController::class)->except(['index']);

        // MONEV INTERNAL
        Route::get('monev-internal-proposal/{id}', [MonevProposalController::class, 'index'])->name('monev-internal-proposal');
        Route::resource('monev-internal-proposal', MonevProposalController::class)->except(['index']);
        Route::get('/monev-internal-reviewer-approval/{id}/{status}', [MonevProposalController::class, 'approval'])->name('monev-internal.approval');
        Route::get('getMonevProposal', [MonevProposalController::class, 'getData'])->name('getMonevProposal');
        Route::get('cetak-daftar-monev-internal', [MonevProposalController::class, 'cetak_daftar_monev_internal'])->name('cetak-daftar-monev-internal');
        Route::get('monev-internal/laporan-anggaran/{id}', [MonevProposalController::class, 'reviewAnggaran'])->name('laporan-anggaran');

        Route::resource('user', UserController::class);
        Route::post('/user/remove-role', [UserController::class, 'removeRole'])->name('remove-role');
        Route::post('/user/add-role', [UserController::class, 'addRole'])->name('add-role');

        Route::resource('user-external', UserExternalController::class);

        Route::resource('pengumuman', PengumumanController::class);

        // cek email apakah sudah ada apa belum
        Route::post('checkemail', [CheckController::class, 'email'])->name('checkemail');
        Route::post('checknidn', [CheckController::class, 'nidn'])->name('checknidn');
    });

    Route::name('reviewer.')->prefix('reviewer')->middleware(['role:reviewer|operator|dosen|tendik'])->group(function () {
        Route::resource('seleksi-internal', DaftarSeleksiController::class);
        Route::get('/seleksi-internal-approval/{id}/{status}', [DaftarSeleksiController::class, 'approval'])->name('seleksi-internal.approval');
        Route::get('getDaftarSeleksi', [DaftarSeleksiController::class, 'getData'])->name('getDaftarSeleksi');

        Route::get('monev-internal/{id}', [DaftarMonevController::class, 'index'])->name('monev-internal');
        Route::resource('monev-internal', DaftarMonevController::class)->except(['index']);
        Route::get('getDaftarMonev', [DaftarMonevController::class, 'getData'])->name('getDaftarMonev');

        Route::get('/luaran/{id}', [luaranMahasiswa::class, 'dosen'])->name('luaran-reviewer');
    });
});

//Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');




