<?php

namespace App\Http\Controllers\Mahasiswa;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\GetDataApiController;

use App\Models\Kelompok;
use App\Models\KelompokDetail;

use Session;
use Alert;
use App\Helpers\InseoHelper;

class AnggotaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $title     = 'Tambah Kelompok Mahasiswa';
        $kode      = null;

        // $getMhs   = GetDataApiController::getAccount(19021264056);
        // dd($getMhs);

        $data = [
            'title' => $title,
            'kode'  => $kode
        ];

        return view('backend.mahasiswa.kelompok.personil.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $kelompok = $request->except('_token');

        $kelompok['fakultas']  = InseoHelper::singkatan_fakultas()[strtolower($kelompok['fakultas'])];

        $cek = KelompokDetail::where('kelompok_id', $kelompok['kelompok_id'])->where('nim', $kelompok['nim'])->count();

        if ($cek > 0) {
            Alert::warning('Mahasiswa sudah terdaftar', '-')->persistent('Ok');

            return redirect()->route('mahasiswa.kelompok.createnew', ['id' => encrypt($kelompok['kelompok_id'])]);
        }

        if ($cek > 5) {
            Alert::warning('Anggota kelompok sudah maksimal', '-');

            return redirect()->route('mahasiswa.kelompok.createnew', ['id' => encrypt($kelompok['kelompok_id'])]);
        }

        KelompokDetail::create($kelompok);

        Alert::success('Berhasil disimpan');

        return redirect()->route('mahasiswa.kelompok.createnew', ['id' => encrypt($kelompok['kelompok_id'])]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($anggotum)
    {
        $anggota = KelompokDetail::find($anggotum);

        if ($anggota && $anggota->status_ketua != 1) {
            $anggota->delete();

            return redirect()->back()->with('success', 'Anggota berhasil dihapus.');
        } else {
            return redirect()->back()->with('error', 'Tidak dapat menghapus ketua atau anggota tidak ditemukan.');
        }
    }
}
