<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DaftarProposal extends Model
{
    protected $table = 'daftar_proposal';
    protected $primaryKey = 'proposal_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'proposal_id', 'jenis_id', 'kode', 'jenis_pkm', 'judul', 'status', 'status_hapus', 'status_administrasi_1', 'status_administrasi_2', 'reviewer_id_1', 'reviewer_id_2', 'status_final', 'nidn_reviewer_id_1', 'nidn_reviewer_id_2', 'upload_dokumen', 'date_upload', 'date_approval', 'identitas_ketua', 'identitas_dospem', 'periode', 'url', 'fakultas',
    ];

    public function rKelompokDetil()
    {
        return $this->hasMany(\App\Models\KelompokDetail::class, 'kelompok_id', 'kelompok_id');
    }

    public function proposalUrl()
    {
        return $this->hasMany(ProposalUrl::class, 'proposal_id', 'proposal_id');
    }

    public function reviewerProposal1()
    {
        return $this->belongsTo(ReviewerProposal::class, 'reviewer_proposal_id_1', 'reviewer_proposal_id');
    }

    public function reviewerProposal2()
    {
        return $this->belongsTo(ReviewerProposal::class, 'reviewer_proposal_id_2', 'reviewer_proposal_id');
    }
}
