<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\UuidTrait;

use Illuminate\Database\Eloquent\Model;

class MonevInternal extends Model
{
    use HasFactory;
    use UuidTrait;

    protected $table = 'monev_internal';
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'id',
        'proposal_id',
        'jenis_monev_id',
        'upload_dokumen',
        'date_upload',
        'date_approval',
        'status',
        'created_user',
        'created_at',
        'updated_user',
        'updated_at',
        'logbook_file',
        'logbook_date',
        'kemajuan_file',
        'kemajuan_date',
        'akhir_file',
        'akhir_date',
        'produk_url',
        'produk_date',
    ];

    public function rProposal()
    {
        return $this->hasOne(Proposal::class, 'proposal_id', 'proposal_id')->with('rKelompok');
    }

    public function rJenisMonev()
    {
        return $this->hasOne(JenisMonev::class, 'jenis_monev_id', 'jenis_monev_id');
    }

    public function rNilai()
    {
        return $this->hasOne(VDaftarProposal::class, 'proposal_id', 'proposal_id')->with(['rReviewerBio1', 'rReviewerBio2']);
    }

    public function rNilaiMonev()
    {
        return $this->hasOne(VDaftarMonev::class, 'proposal_id', 'proposal_id')->where('jenis_monev_id', $this->jenis_monev_id)->with(['rReviewerBio1', 'rReviewerBio2']);
    }

    public function rNilaiMonevAll()
    {
        return $this->hasMany(VDaftarMonev::class, 'proposal_id', 'proposal_id')->with(['rReviewerBio1', 'rReviewerBio2']);
    }

    public function rBuktiAnggaran()
    {
        return $this->hasMany(BuktiAnggaran::class, 'monev_id');
    }
}

