<?php

namespace App\Models;

use App\Models\Proposal;
use Illuminate\Database\Eloquent\Model;

class SeleksiBelmawa extends Model
{
    protected $table = 'seleksi_belmawa';
    protected $primaryKey = 'seleksi_belmawa_id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'seleksi_belmawa_id', 'proposal_id', 'upload_dokumen', 'date_upload', 'status', 'komentar', 'date_approval', 'created_user', 'created_at', 'updated_user', 'updated_at'
    ];

    public function rBelmawa()
    {
        return $this->hasOne(Proposal::class, 'proposal_id', 'proposal_id');
    }
}
