<?php

namespace App\Repositories\Api;

use App\User;
use Auth;
use Illuminate\Support\Str;

class ApiRepository
{
    protected $model;

    public function __construct(User $model)
    {
        $this->model = $model;
    }

    public function login($request)
    {
        $loggedIn = Auth::attempt([
            'email' => $request->user,
            'password' => $request->password,
        ]);

        $status = 'Unauthorized Access';
        $token = 'not generate';

        if ($loggedIn) {
            $status = 'Authorized Access';
            $token = auth()->user()->api_token;

            if (auth()->user()->dt_token < strtotime(date('Y-m-d'))) {
                $token = Str::random(60);
                auth()->user()->update([
                    'api_token' => $token,
                    'dt_token' => strtotime(date('Y-m-d')),
                ]);
            }
        }

        $data = [
            'status' => $status,
            'access_token' => $token,
        ];

        return $data;
    }
}
