<?php

namespace App\Repositories\Auth;

use App\Helpers\InseoHelper;
use GuzzleHttp\Client;

use App\Models\Auth\Biodata;

class BiodataRepository
{
    private $model;

    public function __construct(Biodata $model)
    {
        $this->model = $model;
    }

    public function biodata($auth)
    {
        if ($auth[0]->jenis == 'P') {
            return $this->isdm($auth);
        }

        if ($auth[0]->jenis == 'M') {
            return $this->siakadu($auth);
        }
    }

    public function isdm($auth)
    {
        $client = new Client();
        $apiRequest = $client->request('GET', 'https://i-sdm.unesa.ac.id/biodataumum/'.trim($auth[0]->userid));
        $isdm = json_decode($apiRequest->getBody()->getContents());

        if($isdm[0]->email == null || $isdm[0]->email == '')
        {
            $url = "https://i-sdm.unesa.ac.id/api/email/update/";
            $token = '964cXM2eJmJVGLsj8x3M6gMi9kislGgobrbmzo6880m1mRRc9CLdW9v3Fh7VaLM0';

            $headers = [
                "Authorization" => "Bearer " . $token,
                "Accept" => "application/json",
            ];

            $api_call = $client->request('POST', $url,[
                                'headers' => $headers,
                                'form_params' => [
                                    'nip' => $isdm[0]->nip,
                                    'email' => $auth[0]->email
                                ]
                            ]);

            $call_data = json_decode($api_call->getBody()->getContents());
        }

        // ubah novan karena ambil email dari isdm saja jangan dari auth;
        // $data['email'] = $auth[0]->email;
        // $data['noid'] = $isdm[0]->nip;
        $data['email'] = $auth[0]->email;
        $data['name'] = $isdm[0]->nama;
        $data['noid'] = $isdm[0]->nidn;
        if ($isdm[0]->isdosen == 0) {
            $data['role'] = 'tendik';
        } else {
            $data['role'] = 'dosen';
        }

        if (array_key_exists(strtolower($isdm[0]->namahomebase), InseoHelper::singkatan_fakultas())) {
            $data['fakultas'] = InseoHelper::singkatan_fakultas()[strtolower($isdm[0]->namahomebase)];
        } else {
            $data['fakultas'] = $isdm[0]->namahomebase;
        }
        $data['prodi'] = $isdm[0]->namasatker;

        return $data;
    }

    public function siakadu($auth)
    {
        $userid = trim($auth[0]->userid);
        $client = new Client();
        $URI = 'https://siakadu.unesa.ac.id/api/apiunggun';
        $params['form_params'] = ['kondisi' => 'cekhakakses', 'username' => $userid];
        $response = $client->post($URI, $params);
        $user = unserialize($response->getBody());

        $data['email'] = $auth[0]->email;
        $data['name'] = $user['data_mahasiswa']['nm_pd'];
        $data['noid'] = $user['username'];
        $data['role'] = 'mahasiswa';
        $data['fakultas'] = InseoHelper::singkatan_fakultas()[strtolower($user['nama_fakultas'])];
        $data['prodi'] = $user['nama_prodi'];

        return $data;
    }

    public function find($id = null, $with = null)
    {
        return $this->model
            ->when($with, function ($query) use ($with) {
                return $query->with($with);
            })
            ->when($id, function ($query) use ($id) {
                return $query->where('id', $id);
            })
            ->first();
    }

    public function prodi($id = null, $with = null, $prodi = null, $role = null)
    {
        return $this->model
            ->when($with, function ($query) use ($with) {
                return $query->with($with);
            })
            ->when($id, function ($query) use ($id) {
                return $query->where('id', $id);
            })
            ->when($prodi, function ($query) use ($prodi) {
                return $query->where('kaprodi', $prodi);
            })
            ->when($role, function ($query) use ($role) {
                return $query->whereHas('rolesCustom', function ($query) use ($role) {
                    $query->where('name', $role);
                });
            })
            ->first();
    }

    public function fakultas($id = null, $with = null, $fakultas = null, $role = null)
    {
        return $this->model
            ->when($with, function ($query) use ($with) {
                return $query->with($with);
            })
            ->when($id, function ($query) use ($id) {
                return $query->where('id', $id);
            })
            ->when($fakultas, function ($query) use ($fakultas) {
                return $query->where('dekan', $fakultas);
            })
            ->when($role, function ($query) use ($role) {
                return $query->whereHas('rolesCustom', function ($query) use ($role) {
                    $query->where('name', $role);
                });
            })
            ->first();
    }

    public function unit($id = null, $with = null, $prodi = null, $fakultas = null, $role = null)
    {
        return $this->model
            ->when($with, function ($query) use ($with) {
                return $query->with($with);
            })
            ->when($id, function ($query) use ($id) {
                return $query->where('id', $id);
            })
            ->when($prodi, function ($query) use ($prodi) {
                return $query->where('prodi', $prodi);
            })
            ->when($fakultas, function ($query) use ($fakultas) {
                return $query->where('fakultas', $fakultas);
            })
            ->when($role, function ($query) use ($role) {
                return $query->whereHas('rolesCustom', function ($query) use ($role) {
                    $query->where('name', $role);
                });
            })
            ->first();
    }


}
