@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Dosen</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
            <div class="col-md-4">
                <div class="float-end d-none d-md-block">

                </div>
            </div>
        </div>

    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('dosen.kelompok.index') }}">
                    <div class="row">
                        <div class="col-md-8"></div>
                        <div class="col-md-4 text-right">
                            <div class="row">
                                <label class="col-sm-3 col-form-label"></label>
                                <label class="col-sm-3 col-form-label">Tahun : </label>
                                <div class="col-sm-6">
                                    <select class="form-select" name="year" onchange="this.form.submit()">
                                    @foreach($periode as $per)
                                        <option value="{{ $per->nama }}" {{ $year == $per->nama ? 'selected' : '' }}>{{ $per->nama }}</option>
                                    @endforeach
                                </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    </form>
                    <br>
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered dt-responsive" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr>
                                <th>No</th>
                                <th>Kode Kelompok</th>
                                <th>Ketua</th>
                                <th>NIM</th>
                                <th>Dosen Pembimbing</th>
                                <th>NIDN</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                            </thead>
                            <tbody>
                                @foreach ($kelompok as $item)
                                @php $token = Str::random(30); @endphp
                                <tr id="row-{{ $token }}">
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $item->kode }}</td>
                                    <td>{{ $item->rAnggota->where('status_ketua', 1)->count() > 0 ? $item->rAnggota->where('status_ketua', 1)[0]->nama : '' }}</td>
                                    <td>{{ $item->rAnggota->where('status_ketua', 1)->count() > 0 ? $item->rAnggota->where('status_ketua', 1)[0]->nim : ''}}</td>
                                    <td>{{ $item->nama_dosen }}</td>
                                    <td>{{ $item->nidn_dosen }}</td>
                                    <td>
                                        @if(!is_null($item->kirim))
                                            @if($item->status == 0)
                                                <span class="badge bg-danger">Menunggu Persetujuan Dosen</span>
                                            @else
                                                <span class="badge bg-success">Sudah Disetujui Dosen</span>
                                            @endif
                                        @endif
                                    </td>
                                    <td>

                                        {{-- <button data-bs-toggle="modal" data-bs-target="{{ '#lihat'.$item->kelompok_id }}" href="{{ URL::to('mahasiswa/kelompok-new', encrypt($item->kelompok_id)) }}" class="btn btn-info btn-sm"><i class="far fa-eye"></i> Lihat</button> --}}
                                        <a data-toggle="tooltip"  data-id="{{ $item->kelompok_id }}" data-original-title="Lihat" class="btn btn-info btn-sm lihatDet"><i class="far fa-eye"></i> Lihat</a>

                                        @if($item->status == 0)
                                            <a onclick="setuju('{{ encrypt($item->kelompok_id) }}', 'row-{{ $token }}')" class="btn btn-success btn-sm"><i class="fas fa-check"></i> Setuju</a>
                                            <a onclick="tolak('{{ encrypt($item->kelompok_id) }}', 'row-{{ $token }}')" class="btn btn-danger btn-sm"><i class="fas fa-times"></i> Tolak</a>
                                        @endif

                                        @if((auth()->user()->id == $item->created_user) && ($item->status == 0))
                                            <a href="{{ URL::to('mahasiswa/kelompok-new', encrypt($item->kelompok_id)) }}" class="btn btn-warning btn-sm">Edit</a>
                                            <a onclick="hapus('{{ encrypt($item->kelompok_id) }}', 'row-{{ $token }}')" class="btn btn-danger btn-sm">Hapus</a>
                                        @endif


                                    </div>

                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

    <div id="lihatDetail" class="modal fade">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="lihatLabel">Detail Kelompok</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>
                        <div class="table-responsive">
                            <table class="table table-bordered data-table mb-0" id="tableDetail">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama</th>
                                        <th>NIM</th>
                                        <th>Fakultas</th>
                                        <th>Program Studi</th>
                                        <th>Keterangan</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </p>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script src="{{ asset('theme/js/pages/datatables.init.js') }}"></script>
<script>
    $(document).ready(function() {
        $("#selectmodal").select2({
            dropdownParent: $("#tmbhKel")
        });
    });

    function setuju(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menyetujui Kelompok ini?',
            text: "Kelompok yang di setujui akan di teruskan untuk upload proposal",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('dosen.kelompok.terima') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            position: 'top-center',
                            icon: 'success',
                            title: 'Kelompok berhasil di setujui',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        location.reload();

                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }

    function tolak(id, rowId){
        Swal.fire({
            title: 'Apakah anda yakin untuk menolak kelompok ini?',
            text: "Kelompok yang tidak di setujui tidak bisa untuk upload proposal",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
        }).then((result) => {
            if (result.isConfirmed) {
                var token = '{{ csrf_token() }}';
                var request = $.ajax({
                    url: '{{ route('dosen.kelompok.tolak') }}',
                    type: 'POST',
                    dataType: 'html',
                    data: {id:id, _token:token},
                    success: function(data){
                        Swal.fire({
                            position: 'top-center',
                            icon: 'success',
                            title: 'Kelompok berhasil di tolak',
                            showConfirmButton: false,
                            timer: 1500
                        });

                        location.reload();

                    },
                    error: function(xhr, status, error){
                        Swal.fire({
                            position: 'top-end',
                            icon: 'error',
                            title: xhr.responseText,
                            showConfirmButton: false,
                            timer: 3500
                        });
                    }
                });
            }
        })
    }

    $(document).ready(function(){

        $('#datatable').on('click','.lihatDet',function(){
            var kelId = $(this).attr('data-id');

        if(kelId != null || kelId != ''){
                // Empty modal data
                $('#tableDetail tbody').empty();

                $.ajax({
                    url: "{{route('dosen.kelompok.lihat')}}",
                    data : {
                        "kelompok_id": kelId,
                    },
                    dataType: 'json',
                    success: function(response){
                        // Add user details
                        $('#tableDetail tbody').html(response.html);

                        // Display Modal
                        $('#lihatDetail').modal('show');
                    }
                });
            }
        });

    });

</script>
@endsection
