@extends('layouts.master')

@section('title')
    Dashboard
@endsection

@section('header')
<div class="page-title">
    <h3>Dashboard</h3>
</div>
@endsection

@section('contents')
    <!-- start page title -->
    <div class="page-title-box">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h6 class="page-title">{!! $title !!}</h6>
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item">Mahasiswa</li>
                    <li class="breadcrumb-item">Monev</li>
                    <li class="breadcrumb-item">{!! $title !!}</li>
                </ol>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('mahasiswa.monev-revisi-upload') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                    <h4 class="card-title">{!! $title !!}</h4>
                    <p class="card-title-desc"></p>
                    <div class="row mb-3">
                        {{-- @dd($proposal->id); --}}
                        <input class="form-control" type="hidden" id="monev_id" name="monev_id" value="{{ $proposal->id }}" >
                        <input class="form-control" type="hidden" id="type" name="type" value="{{ $type }}" >
                        <input class="form-control" type="hidden" id="monev" name="monev" value="{{ $monev }}" >
                        <label for="input-form" class="col-sm-2 col-form-label">Judul</label>
                        <label for="input-form" class="col-sm-10 col-form-label">{{ $proposal->rProposal->judul }}</label>
                    </div>
                    <div class=" row mb-3">
                        <label for="input-form" class="col-sm-2 col-form-label">Kategori PMW</label>
                        <label for="input-form" class="col-sm-10 col-form-label">{{ $proposal->rProposal->rJenis->nama }}</label>
                    </div>
                    <div class=" row mb-3">
                        <label for="input-form" class="col-sm-2 col-form-label">Komentar Review</label>
                        <label for="input-form" class="col-sm-10 col-form-label">
                            <h4 class="card-title mb-4">Reviewer 1 - {{ $proposal->rNilaiMonev->rReviewerBio1 ? $proposal->rNilaiMonev->rReviewerBio1->nama : '' }}</h4>
                            <p class="text-muted mb-3 pb-4">" {{ $proposal->rNilaiMonev->reviewer_komentar_1 }}"</p>

                            <h4 class="card-title mb-4">Reviewer 2 - {{ $proposal->rNilaiMonev->rReviewerBio2 ? $proposal->rNilaiMonev->rReviewerBio2->nama : '' }}</h4>
                            <p class="text-muted mb-3 pb-4">" {{ $proposal->rNilaiMonev->reviewer_komentar_2 }}"</p>
                        </label>
                    </div>
                    <div class="row mb-3" class="dropzone">
                        <label for="input-form" class="col-sm-2 col-form-label">{{ $label }}</label>
                        {{-- <label for="kode" class="col-sm-2 col-form-label">Upload Revisi Proposal</label>
                        <div class="col-sm-10">
                            @if ($errors->has('file')) <span class="text-danger">{{ $errors->first('file') }}</span> @endif
                            <input type="file" name="file" class="form-control" id="input-file">
                            <iframe id="view-pdf" width="80%" height="80%" src="" frameborder="0"></iframe>
                        </div> --}}
                        @if($type == 'produk')
                            <div class="col-sm-10">
                                @if ($errors->has('produk_url')) 
                                    <span class="text-danger">{{ $errors->first('produk_url') }}</span> 
                                @endif
                                <input type="text" name="produk_url" class="form-control" id="input-form" value="{{ old('produk_url') }}" required>
                            </div>
                        @else
                            <div class="col-sm-10">
                                <div class="row">
                                    <div class="col-8">
                                        <input type="file" name="file" class="form-control" id="input-file" accept="application/pdf" required>
                                        @if ($errors->has('file')) 
                                            <span class="text-danger">{{ $errors->first('file') }}</span> 
                                        @endif
                                    </div>
                                    <div class="col-4">
                                        <button type="button" class="btn btn-warning form-control" id="btnPreview">Preview</button>
                                    </div>
                                </div>
                                {{-- <iframe id="view-pdf" width="80%" height="80%" src="" frameborder="0"></iframe> --}}
                            </div>
                        @endif
                    </div>
                    <div class="mb-0">
                        <div>
                            <button type="submit" class="btn btn-primary waves-effect waves-light me-1"> Submit </button>
                            <button type="button" onclick="window.history.back();" class="btn btn-secondary waves-effect"> Cancel </button>
                        </div>
                    </div>
                </form>
                <br>
                <h6 class="text-danger">* PASTIKAN FILE PROPOSAL SUDAH BENAR SEBELUM DISUBMIT</h6>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row -->

    <!-- Modal Preview -->
    <div class="modal fade" id="pdfModal" tabindex="-1" role="dialog" aria-labelledby="pdfModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content" style="height: 80vh;">
                <div class="modal-header">
                    <h5 class="modal-title" id="pdfModalLabel">Preview PDF</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">{{-- <span aria-hidden="true">&times;</span> --}}</button>
                </div>
                <div class="modal-body">
                    {{-- <iframe id="pdfViewer" width="100%" height="100%" frameborder="0"></iframe> --}}
                    {{-- <iframe id="view-pdf" width="100%" height="450" frameborder="0" src="{{ $proposal ? 'https://statik.unesa.ac.id/simpkm/proposal/'.$proposal->rPeriode->nama.'/'.$proposal->upload_dokumen : '' }} "></iframe> --}}
                    <iframe id="view-pdf" width="100%" height="100%"></iframe>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')

<script>
    // $(function(){
    //     $('#input-form').change(function(){
    //         var input = this;
    //         var url = window.URL.createObjectURL(this.files[0]);
    //         $('#view-pdf').attr('src',url);
    //         $('#view-pdf').attr('height','500px');
    //     })
    // })

    document.getElementById('btnPreview').addEventListener('click', function() {
    var fileInput = document.getElementById('input-file');
    var file = fileInput.files[0];

    // Konversi ukuran maksimum menjadi bytes (5MB = 5 * 1024 * 1024 bytes)
    var maxSize = 5 * 1024 * 1024; 

    if (file) {
        if (file.type === "application/pdf") {
            if (file.size <= maxSize) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    var pdfData = e.target.result;

                    var iframe = document.getElementById('view-pdf');
                    iframe.src = pdfData;

                    var modal = new bootstrap.Modal(document.getElementById('pdfModal'));
                    modal.show();
                };

                reader.readAsDataURL(file);
            } else {
                alert("Ukuran file lebih dari 5MB. Harap unggah file yang lebih kecil.");
            }
        } else {
            alert("Harap unggah file PDF untuk preview/submit.");
        }
    } else {
        alert("Harap pilih file untuk diunggah.");
    }
});
</script>

@endsection
