<?php

namespace App\Exports;

use App\Models\DaftarProposal;

use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
// use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class DaftarProposalExport implements FromView
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function __construct($jenis,$status,$tahun)
    {
        $this->jenis= $jenis;
        $this->status = $status;
        $this->tahun= $tahun;
    }

    public function view(): View
    {
        // ini_set('memory_limit', '-1');
        $statement = " STATUS_HAPUS = '0' ";

        if($this->jenis != "0")
        {
            $statement .= " AND jenis_id = '{$this->jenis}'";
        }

        if($this->status != "0")
        {
            // dikurang 1 karena di view mulai dari 0 sedangkan 0 itu menunggu persetujuan
            $status = $this->status - 1;
            $statement .= " AND STATUS_FINAL = '{$status}'";
        }

        if($this->tahun != "0")
        {
            $statement .= " AND PERIODE = '{$this->tahun}'";
        }

        $data = DaftarProposal::with(['rKelompokDetil', 'reviewerProposal1', 'reviewerProposal2'])
        ->select("*")
        ->selectRaw(" round((ambil_jumlah_penilaian_seleksi(reviewer_proposal_id_1) + ambil_jumlah_penilaian_seleksi(reviewer_proposal_id_2 )) / 2, 2) as rata ")
        ->whereRaw($statement)
        ->get();
        // dd($statement);

        $result = [];

        $x =0;
        $dospem = '';
        foreach ($data as $key => $value) {
            // $dospem = "(".str_replace("###",") ",$value->identitas_dospem);
            $data_dospem = explode('###', $value->identitas_dospem);
            $data_ketua = explode('###', $value->identitas_ketua);
            $dospem = "(".$data_dospem[0].") ".$data_dospem[1];
            $url = "https://statik.unesa.ac.id/simpmw/proposal/".$value->periode."/".$value->upload_dokumen;

            if($value->status_final == '1')
                $status_final = "Lolos";
            elseif($value->status_final == '2')
                $status_final = "Tidak Lolos";
            else
                $status_final = "Menunggu Persetujuan";

            $urut = 1;
            $det = array();
            $no = 0;
            foreach ($value->rKelompokDetil as $keys => $detil) {

                if($detil->status_ketua == '1')
                {
                    $keanggotaan = "Ketua";
                }
                else
                {
                    $keanggotaan = "Anggota ".$urut;
                    $urut++;
                }

                $det[$no]['fak'] = $detil->fakultas;
                $det[$no]['nama'] = $detil->nama;
                $det[$no]['nim']= $detil->nim;
                $det[$no]['keanggotaan'] = $keanggotaan;

                $no++;
            }

            $result[$x]['rowspan'] = count($value->rKelompokDetil);
            $result[$x]['kode'] = $value->kode;
            $result[$x]['jenis'] = $value->jenis_pkm;
            $result[$x]['detil'] = $det;
            $result[$x]['judul'] = $value->judul;
            $result[$x]['dospem'] = $dospem;
            $result[$x]['link'] = $url;
            $result[$x]['video'] = $value->url;
            $result[$x]['status'] = $status_final;
            $result[$x]['rata'] = $value->rata;
            $result[$x]['email_dospem'] = end($data_dospem);
            $result[$x]['email_ketua'] = end($data_ketua);

            $x++;
        }

        $datas['list_proposal'] = $result;
        // dd($result);
        $datas['jenis_monev'] = 'Seleksi Internal';

        return view('backend.operator.daftar_proposal.excel_new', $datas);
    }
}
