<?php

namespace App\Exports;

use App\Models\DaftarProposal;

use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
// use Maatwebsite\Excel\Concerns\ShouldAutoSize;

// class ProposalExport implements FromView,ShouldAutoSize
class ProposalExport implements FromView
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function __construct($fakultas,$jenis,$status,$tahun)
    {
        $this->fakultas = $fakultas;
        $this->jenis= $jenis;
        $this->status = $status;
        $this->tahun= $tahun;
    }

    public function view(): View
    {
        $statement = " STATUS_HAPUS = '0' ";

        if($this->fakultas != "0")
        {
            $statement .= " AND split_part(IDENTITAS_KETUA, '###', 3) = '".$this->fakultas."'";
        }

        if($this->jenis != "0")
        {
            $statement .= " AND jenis_id = '{$this->jenis}'";
        }

        if($this->status != "0")
        {
            // dikurang 1 karena di view mulai dari 0 sedangkan 0 itu menunggu persetujuan
            $status = $this->status - 1;
            $statement .= " AND STATUS = '{$status}'";
        }

        if($this->tahun != "0")
        {
            $statement .= " AND PERIODE = '{$this->tahun}'";
        }

        $data = DaftarProposal::with('rKelompokDetil')
            ->whereRaw($statement)
            ->orderBy('kode', 'ASC')
            ->get();
                
        $result = [];

        $no = 0;

        foreach ($data as $key => $value) {
            $dospem = str_replace("###","\n",$value->identitas_dospem);
            $url = "https://statik.unesa.ac.id/simpmw/proposal/".$value->periode."/".$value->upload_dokumen;

            $urut = 1;
            $row = [
                'kode'      => $value->kode,
                'jenis'     => $value->jenis_pkm,
                'judul'     => $value->judul,
                'usulan'    => $value->usulan_dana,
                'dospem'    => $dospem,
                'link'      => $url,
                'video'     => $value->url,
                'periode'   => $value->periode,
                'status'    => $value->status,
                'kelompok' => [],
            ];
    
            foreach ($value->rKelompokDetil as $detil) {
                if ($detil->status_ketua == '1') {
                    $keanggotaan = "Ketua";
                } else {
                    $keanggotaan = "Anggota " . $urut;
                    $urut++;
                }
                
                $row['kelompok'][] = [
                    'fak' => $detil->fakultas,
                    'prodi' => $detil->prodi,
                    'nama' => $detil->nama,
                    'nim' => $detil->nim,
                    'keanggotaan' => $keanggotaan,
                ];
            }
    
            $result[] = $row;
        }

        $datas['list_proposal'] = $result;
        $datas['req_fakultas'] = $this->fakultas;

        return view('backend.operator.proposal.excel', $datas);
    }
}
