<?php

namespace App\Http\Controllers\Dosen;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\GetDataApiController;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

use App\Models\Proposal;
use App\Models\Kelompok;
use App\Models\Periode;
use App\Models\Jenis;

use Session;
use Alert;
use App\Models\DaftarProposal;
use Auth;
use DB;

class SeleksiController extends Controller
{
    public function seleksiInternal(Request $request)
    {
        //
        $title    = 'Seleksi Internal Mahasiswa';
        $bio      = auth()->user()->rBiodata;
        $nim      = $bio->noidentitas;
        $periode  = Periode::query()->get();
        $year     = !is_null($request->year) ? $request->year : now()->year;

        $proposal = Proposal::with(['rKelompok', 'rJenis', 'rDaftarPro'])
                    ->whereHas('rKelompok', function ($query) use($bio){
                        $query->where('nidn_dosen', $bio->noidentitas);
                    })
                    ->whereYear('created_at', $year)
                    ->orderBy('kelompok_id')
                    ->get();

        $data = [
            'proposal'  => $proposal,
            'title'     => $title,
            'periode'   => $periode,
            'year'      => $year,
        ];

        return view('backend.dosen.seleksi.index_internal', $data);
    }

    public function seleksiBelmawa(Request $request)
    {
        //
        $title    = 'Seleksi Belmawa Mahasiswa';
        $bio      = auth()->user()->rBiodata;
        $nim      = $bio->noidentitas;
        $periode  = Periode::query()->get();
        $year     = !is_null($request->year) ? $request->year : now()->year;

        $proposal = Proposal::with(['rKelompok', 'rJenis'])
                    ->whereHas('rKelompok', function ($query) use($bio){
                        $query->where('nidn_dosen', $bio->noidentitas);
                    })
                    ->whereYear('created_at', $year)
                    ->orderBy('kelompok_id')
                    ->get();

        $data = [
            'proposal'  => $proposal,
            'title'     => $title,
            'periode'   => $periode,
            'year'      => $year,
        ];

        return view('backend.dosen.seleksi.index_belmawa', $data);
    }

    public function lihatInternal(Request $request)
    {

        $item = DaftarProposal::where('proposal_id', $request->proposal_id)->first();
        $item['url'] = DaftarProposal::where('proposal_id', $request->proposal_id)->get();

        $nilai_1= DB::select("select ambil_jumlah_penilaian_seleksi('".$item->reviewer_proposal_id_1."', '".$item->jenis_id."')")[0]->ambil_jumlah_penilaian_seleksi;
        $nilai_2= DB::select("select ambil_jumlah_penilaian_seleksi('".$item->reviewer_proposal_id_2."', '".$item->jenis_id."')")[0]->ambil_jumlah_penilaian_seleksi;

        $rata = number_format((float) (($nilai_1 + $nilai_2) / 2), 0, '.', '');

        $data = '';
        $link = '';
        foreach ($item['url'] as $surel) {
            $link .= $surel->url;
        }
        // dd($surel->url);

            if($item->upload_dokumen){
                $dokumen = ' <a href="https://statik.unesa.ac.id/simpmw/proposal/'. $item->periode .'/'. $item->upload_dokumen.'"  target="_blank" class="btn btn-success btn-sm"> <i class="far fa-eye"></i> Lihat Proposal</a>
                             <iframe id="view-pdf" width="100%" height="400px" src="https://statik.unesa.ac.id/simpmw/proposal/'. $item->periode .'/'.$item->upload_dokumen .'" frameborder="0"></iframe>';
                $url = '<a class="btn btn-success btn-sm" target="_blank" href="'. $link .'"><i class="far fa-eye"></i> Lihat Video</a>';
                }else{
                $dokumen = '<div class="alert alert-danger alert-dismissible fade show mb-0" role="alert">
                                <strong>Informasi!</strong><br/> File tidak ditemukan.
                            </div>';
                $url = '<div class="alert alert-danger alert-dismissible fade show mb-0" role="alert">
                            <strong>Informasi!</strong><br/> File tidak ditemukan.
                        </div>';
                }

            if(is_null($item->status)){
                $status = '<span class="badge bg-danger">Menunggu Persetujuan Dosen</span>';
            }else{
                $status = '<span class="badge bg-success">Sudah Disetujui Dosen</span>';
            }

            $data .= "
                        <tr>
                                <td>Judul Proposal</td>
                                <td>".$item->judul."</td>
                            </tr>
                            <tr>
                                <td>Kategori PMW</td>
                                <td>".$item->jenis_pkm."</td>
                            </tr>
                            <tr>
                                <td>Status</td>
                                <td>".$status."</td>
                            </tr>
                            <tr>
                                <td>Proposal</td>
                                <td>".$dokumen."</td>
                            </tr>
                            <tr>
                                <td>Video Produk</td>
                                <td>".$url."</td>
                            </tr>
                            <tr>
                                <td>Komentar</td>
                                <td>
                                <h4 class='card-title mb-4'>Nilai Total </h4>
                                <p class='text-muted mb-3 pb-4'>". $rata ."</p>

                                <h4 class='card-title mb-4'>Reviewer 1 </h4>
                                <p class='text-muted mb-3 pb-4'>".$item->reviewer_komentar_1."</p>

                                <h4 class='card-title mb-4'>Reviewer 2 </h4>
                                <p class='text-muted mb-3 pb-4'>".$item->reviewer_komentar_2."</p>
                                </td>
                            </tr>

                    ";

        $response['html'] = $data;
        echo json_encode($response);

    }
}
