<?php

namespace App\Http\Controllers\Mahasiswa;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\GetDataApiController;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

use App\Models\Proposal;
use App\Models\ProposalLuaran;

use Session;
use Alert;
use Auth;

class LuaranController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $luaran   = $request->except('_token');

        $proposal = Proposal::with(['rPeriode'])->find($luaran['proposal_id']);

        $this->validate($request,
        [
            'file' => 'required|mimes:pdf|max:5000'
        ], [
            'file.required' => 'Tidak ada file yang di upload',
            'file.mimes' => 'File harus pdf',
            'file.max' => 'File tidak boleh lebih dari 5 mb',
        ]);


        $file_nama  = $proposal->rPeriode->nama.'_'.$proposal->proposal_id.'_'.$luaran['jenis_luaran'].'.'.$luaran['file']->getClientOriginalExtension();

        Storage::disk('static')->put('simpmw/luaran/'.$luaran['jenis_luaran'].'/'.$file_nama, file_get_contents($luaran['file']->getRealPath()));

        ProposalLuaran::create([
            'proposal_id'       => $luaran['proposal_id'],
            'judul'             => $luaran['judul'],
            'jenis_luaran'      => $luaran['jenis_luaran'],
            'keterangan_luaran' => $luaran['keterangan_luaran'],
            'kategori_luaran'   => $luaran['jenis_luaran_lainnya'] === 'Lainnya' ? $luaran['jenis_luaran_lainnya'] : null,
            'file_luaran'       => $file_nama,
            'created_user'      => Auth::user()->id,
            'updated_user'      => Auth::user()->id
        ]);

        return redirect()->route('mahasiswa.luaran.show', encrypt($luaran['proposal_id']))->with('success', 'Proposal Berhasil ditambahkan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $title    = 'Unggah Laporan Magang Mahasiswa';
        $proposal = Proposal::with(['rluaran', 'rPeriode'])->find(decrypt($id));

        $data = [
            'proposal'  => $proposal,
            'title'     => $title
        ];

        return view('backend.mahasiswa.luaran.index', $data);
    }

    public function hapus(Request $request)
    {
        $pro = $request->except('_token');

        // Dekripsi ID hanya sekali
        $id = decrypt($pro['id']);
        
        $proposal = ProposalLuaran::query()->find($id);

        if ($proposal) {
            Storage::disk('static')->delete('simpmw/luaran/'.$proposal->jenis_luaran.'/'.$proposal->file_luaran);
            $proposal->delete();
            return response()->json(['status' => 'success', 'message' => 'Berhasil dihapus']);
        } else {
            return response()->json(['status' => 'error', 'message' => 'Proposal tidak ditemukan']);
        }
    }

    public function dosen($id)
    {
        //
        $title    = 'Laporan Magang Mahasiswa';
        $proposal = Proposal::with(['rLuaran', 'rPeriode'])->find(decrypt($id));

        $data = [
            'proposal'  => $proposal,
            'title'     => $title
        ];

        return view('backend.dosen.luaran.index', $data);
    }
}
