<?php

namespace App\Models;

use App\Traits\UuidTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

class BuktiAnggaran extends Model
{
    use HasFactory, SoftDeletes, UuidTrait;

    protected $table = 'bukti_anggaran';
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'proposal_id',
        'monev_id',
        'nama_kegiatan',
        'nama_barang',
        'tgl_pembelian',
        'kuantitas',
        'jenis_satuan',
        'harga_satuan',
        'total_harga_per',
        'total_harga_seluruh',
        'nota_file',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
        'deleted_at',
        'deleted_by',
    ];

    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    // Jika ada relasi, tambahkan disini
    public function rProposal()
    {
        return $this->belongsTo(Proposal::class, 'proposal_id', 'proposal_id');
    }

    public function rMonev()
    {
        return $this->belongsTo(MonevInternal::class, 'monev_id', 'id');
    }
}
