<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DaftarProposalMonev extends Model
{
    protected $table = 'daftar_proposal_monev';
    protected $primaryKey = 'reviewer_monev_id';
    public $incrementing = false;

    protected $fillable = [
        'monev_internal_id', 'proposal_id', 'jenis_monev_id', 'kode', 'judul',
        'jenis_pkm', 'jenis_monev', 'jenis_monev_desc', 'status', 'status_administrasi_1', 'status_administrasi_2',
        'nilai_1', 'nilai_2', 'reviewer_komentar_1', 'reviewer_komentar_2', 'reviewer_monev_id_1',
        'reviewer_monev_id_2', 'reviewer_id_1', 'reviewer_id_2', 'kelompok_id', 'fakultas_ketua', 'status_hapus', 'status', 'periode',

        // 'proposal_id', 'reviewer_monev_id', 'jenis_id', 'kode', 'jenis_pkm', 'judul', 'status', 'status_administrasi_1', 'status_administrasi_2', 'nilai_1', 'nilai_2', 'reviewer_monev_id_1', 'reviewer_monev_id_1', 'status_final'
    ];

    public function rKelompokDetil()
    {
        return $this->hasMany(\App\Models\KelompokDetail::class, 'kelompok_id', 'kelompok_id');
    }

    public function proposalUrl()
    {
        return $this->belongsTo(ProposalUrl::class, 'proposal_id', 'proposal_id');
    }
}
